/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.core.world.TickHandlerWorld;
import cofh.lib.util.ChunkCoord;
import cofh.lib.util.LinkedHashList;
import cofh.lib.world.IFeatureGenerator;
import cofh.lib.world.IFeatureHandler;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldHandler
implements IWorldGenerator,
IFeatureHandler {
    private static List<IFeatureGenerator> features = new ArrayList<IFeatureGenerator>();
    private static Set<String> featureNames = new THashSet();
    private static Set<OreGenEvent.GenerateMinable.EventType> vanillaGenEvents = new THashSet();
    private static LinkedHashList<ChunkReference> populatingChunks = new LinkedHashList();
    private static long genHash = 0L;
    private static final String TAG_NAME = "CoFHWorld";
    private static final int MAX_BEDROCK_LAYERS = 8;
    private static int layersBedrock = 1;
    private static boolean genFlatBedrock = false;
    private static boolean retroFlatBedrock = false;
    private static boolean retroGeneration = false;
    private static boolean forceFullRegeneration = false;
    static boolean genReplaceVanilla = false;
    public static ArrayList<String> registeredFeatureNames = new ArrayList();
    public static WorldHandler instance = new WorldHandler();

    public static void initialize() {
        String category = "World";
        String comment = "If TRUE, vanilla Minecraft ore generation will be REPLACED. Configure in the vanilla.json file; vanilla defaults have been provided. If you rename the vanilla.json file, this option WILL NOT WORK.";
        genReplaceVanilla = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("ReplaceVanillaGeneration", category, genReplaceVanilla, comment);
        comment = "If TRUE, world generation handled by CoFH Core will be retroactively applied to existing chunks.";
        retroGeneration = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("RetroactiveGeneration", category, retroGeneration, comment);
        category = "World.Bedrock";
        comment = "If TRUE, the bedrock layer will be flattened.";
        genFlatBedrock = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("FlatBedrockEnable", category, genFlatBedrock, comment);
        comment = "This adjusts the number of layers of Flat Bedrock, if enabled.";
        layersBedrock = CoFHCore.CONFIG_CORE.getConfiguration().getInt("FlatBedrockLayers", category, 2, 1, 8, comment);
        comment = "If TRUE, Flat Bedrock will retroactively be applied to existing chunks, if enabled.";
        retroFlatBedrock = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("FlatBedrockRetroactive", category, retroFlatBedrock, comment);
        GameRegistry.registerWorldGenerator((IWorldGenerator)instance, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.ORE_GEN_BUS.register((Object)instance);
        GameRegistry.registerWorldGenerator((random, chunkX, chunkZ, world, chunkGenerator, chunkProvider) -> populatingChunks.remove(new ChunkReference(world.field_73011_w.getDimension(), chunkX, chunkZ)), (int)Integer.MAX_VALUE);
        if (genFlatBedrock & retroFlatBedrock | retroGeneration) {
            MinecraftForge.EVENT_BUS.register((Object)TickHandlerWorld.instance);
        }
    }

    public boolean removeFeature(IFeatureGenerator feature) {
        String featureName = feature.getFeatureName();
        if (featureName == null) {
            return false;
        }
        if (featureNames.contains(featureName)) {
            featureNames.remove(featureName);
            features.remove(feature);
            genHash -= (long)featureName.hashCode();
        }
        return true;
    }

    private WorldHandler() {
    }

    @SubscribeEvent
    public void populateChunkEvent(PopulateChunkEvent.Pre event) {
        populatingChunks.add(new ChunkReference(event.getWorld().field_73011_w.getDimension(), event.getChunkX(), event.getChunkZ()));
    }

    @SubscribeEvent
    public void populateChunkEvent(PopulateChunkEvent.Post event) {
        ChunkReference pos = populatingChunks.get(new ChunkReference(event.getWorld().field_73011_w.getDimension(), event.getChunkX(), event.getChunkZ()));
        if (pos != null) {
            pos.hasVillage = event.isHasVillageGenerated();
        }
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(TAG_NAME);
        ChunkReference chunk = populatingChunks.get(event.getChunk());
        if (chunk != null) {
            genTag.func_74757_a("Populating", true);
            genTag.func_74757_a("HasVillage", chunk.hasVillage);
            return;
        }
        if (genFlatBedrock) {
            genTag.func_74757_a("Bedrock", true);
        }
        NBTTagList featureList = new NBTTagList();
        for (int i = 0; i < features.size(); ++i) {
            featureList.func_74742_a((NBTBase)new NBTTagString(features.get(i).getFeatureName()));
        }
        genTag.func_74782_a("List", (NBTBase)featureList);
        genTag.func_74772_a("Hash", genHash);
        event.getData().func_74782_a(TAG_NAME, (NBTBase)genTag);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(TAG_NAME);
        if (tag != null && tag.func_74767_n("Populating")) {
            ChunkReference chunk = new ChunkReference(dim, event.getChunk().field_76635_g, event.getChunk().field_76647_h);
            chunk.hasVillage = tag.func_74767_n("HasVillage");
            populatingChunks.add(chunk);
            return;
        }
        NBTTagList list = null;
        ChunkCoord cCoord = new ChunkCoord(event.getChunk());
        if (tag != null) {
            boolean bedrock;
            boolean genFeatures = false;
            boolean bl = bedrock = retroFlatBedrock & genFlatBedrock && !tag.func_74764_b("Bedrock");
            if (retroGeneration) {
                boolean bl2 = genFeatures = tag.func_74763_f("Hash") != genHash;
                if (tag.func_74764_b("List")) {
                    list = tag.func_150295_c("List", 8);
                    genFeatures |= list.func_74745_c() != features.size();
                }
            }
            if (bedrock) {
                CoFHCore.LOG.debug("Queuing RetroGen for flattening bedrock for the chunk at " + cCoord.toString() + ".");
                regen = true;
            }
            if (genFeatures) {
                CoFHCore.LOG.debug("Queuing RetroGen for features for the chunk at " + cCoord.toString() + ".");
                regen = true;
            }
        } else {
            regen = retroFlatBedrock & genFlatBedrock | retroGeneration;
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)TickHandlerWorld.chunksToGen.get(dim);
            if (chunks == null) {
                TickHandlerWorld.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)TickHandlerWorld.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(new TickHandlerWorld.RetroChunkCoord(cCoord, list));
                TickHandlerWorld.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void handleOreGenEvent(OreGenEvent.GenerateMinable event) {
        if (!genReplaceVanilla) {
            return;
        }
        if (vanillaGenEvents.contains(event.getType())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    @Override
    public boolean registerFeature(IFeatureGenerator feature) {
        String featureName = feature.getFeatureName();
        if (featureName == null) {
            CoFHCore.LOG.error("Feature attempted to register without providing a valid name... ignoring.");
            return false;
        }
        if (featureNames.contains(featureName)) {
            CoFHCore.LOG.debug("Feature " + featureName + " was attempting to register a second time... ignoring.");
            return false;
        }
        featureNames.add(featureName);
        features.add(feature);
        genHash += (long)featureName.hashCode();
        return true;
    }

    public static boolean addFeature(IFeatureGenerator feature) {
        return instance.registerFeature(feature);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        this.replaceBedrock(random, chunkX, chunkZ, world, newGen | forceFullRegeneration);
        if (!newGen & !retroGeneration) {
            return;
        }
        ChunkReference pos = new ChunkReference(world.field_73011_w.getDimension(), chunkX, chunkZ);
        boolean hasVillage = (pos = populatingChunks.get(pos)) == null ? false : pos.hasVillage;
        for (IFeatureGenerator feature : features) {
            BlockFalling.field_149832_M = true;
            feature.generateFeature(random, chunkX, chunkZ, world, hasVillage, newGen | forceFullRegeneration);
        }
        BlockFalling.field_149832_M = false;
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void generateWorld(Random random, TickHandlerWorld.RetroChunkCoord chunk, World world, boolean newGen) {
        int chunkX = chunk.coord.chunkX;
        int chunkZ = chunk.coord.chunkZ;
        if ((newGen | retroGeneration) & forceFullRegeneration) {
            this.generateWorld(random, chunkX, chunkZ, world, newGen);
            return;
        }
        this.replaceBedrock(random, chunkX, chunkZ, world, newGen | forceFullRegeneration);
        if (!newGen & !retroGeneration) {
            return;
        }
        THashSet<String> genned = chunk.generatedFeatures;
        ChunkReference pos = new ChunkReference(world.field_73011_w.getDimension(), chunkX, chunkZ);
        boolean hasVillage = (pos = populatingChunks.get(pos)) == null ? false : pos.hasVillage;
        for (IFeatureGenerator feature : features) {
            if (genned.contains((Object)feature.getFeatureName())) continue;
            BlockFalling.field_149832_M = true;
            feature.generateFeature(random, chunkX, chunkZ, world, hasVillage, newGen | forceFullRegeneration);
        }
        BlockFalling.field_149832_M = false;
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void replaceBedrock(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!genFlatBedrock | !newGen & !retroFlatBedrock) {
            return;
        }
        int offsetX = chunkX * 16;
        int offsetZ = chunkZ * 16;
        boolean isVoidAge = !world.func_180495_p(new BlockPos(offsetX, 0, offsetZ)).func_177230_c().func_149667_c(Blocks.field_150357_h);
        isVoidAge |= !world.func_180495_p(new BlockPos(offsetX + 4, 0, offsetZ + 4)).func_177230_c().func_149667_c(Blocks.field_150357_h);
        isVoidAge |= !world.func_180495_p(new BlockPos(offsetX + 8, 0, offsetZ + 8)).func_177230_c().func_149667_c(Blocks.field_150357_h);
        if (isVoidAge |= !world.func_180495_p(new BlockPos(offsetX + 12, 0, offsetZ + 12)).func_177230_c().func_149667_c(Blocks.field_150357_h)) {
            return;
        }
        IBlockState filler = world.func_180494_b((BlockPos)new BlockPos((int)offsetX, (int)0, (int)offsetZ)).field_76753_B;
        boolean meta = false;
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                filler = Blocks.field_150424_aL.func_176223_P();
                break;
            }
            case 0: {
                filler = Blocks.field_150348_b.func_176223_P();
                break;
            }
            case 1: {
                filler = Blocks.field_150377_bs.func_176223_P();
            }
        }
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                IBlockState state;
                BlockPos pos;
                int blockY;
                for (blockY = 5; blockY > layersBedrock - 1; --blockY) {
                    pos = new BlockPos(offsetX + blockX, blockY, offsetZ + blockZ);
                    state = world.func_180495_p(pos);
                    if (!state.func_177230_c().func_149667_c(Blocks.field_150357_h)) continue;
                    world.func_180501_a(pos, filler, 2);
                }
                for (blockY = layersBedrock - 1; blockY > 0; --blockY) {
                    pos = new BlockPos(offsetX + blockX, blockY, offsetZ + blockZ);
                    state = world.func_180495_p(pos);
                    if (state.func_177230_c().func_149667_c(Blocks.field_150357_h)) continue;
                    world.func_180501_a(pos, Blocks.field_150357_h.func_176223_P(), 2);
                }
            }
        }
        int worldHeight = world.func_72940_L();
        if (world.func_180495_p(new BlockPos(offsetX, worldHeight - 1, offsetZ)).func_177230_c().func_149667_c(Blocks.field_150357_h)) {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    IBlockState state;
                    BlockPos pos;
                    int blockY;
                    for (blockY = worldHeight - 2; blockY > worldHeight - 6; --blockY) {
                        pos = new BlockPos(offsetX + blockX, blockY, offsetZ + blockZ);
                        state = world.func_180495_p(pos);
                        if (!state.func_177230_c().func_149667_c(Blocks.field_150357_h)) continue;
                        world.func_180501_a(pos, filler, 2);
                    }
                    for (blockY = worldHeight - layersBedrock; blockY < worldHeight - 1; ++blockY) {
                        pos = new BlockPos(offsetX + blockX, blockY, offsetZ + blockZ);
                        state = world.func_180495_p(pos);
                        if (state.func_177230_c().func_149667_c(Blocks.field_150357_h)) continue;
                        world.func_180501_a(pos, Blocks.field_150357_h.func_176223_P(), 2);
                    }
                }
            }
        }
    }

    static {
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.ANDESITE);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.COAL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIAMOND);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIORITE);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIRT);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.EMERALD);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GOLD);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GRANITE);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GRAVEL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.IRON);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.LAPIS);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.REDSTONE);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.QUARTZ);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.SILVERFISH);
    }

    private static class ChunkReference {
        public final int dimension;
        public final int xPos;
        public final int zPos;
        public boolean hasVillage;

        public ChunkReference(int dim, int x, int z) {
            this.dimension = dim;
            this.xPos = x;
            this.zPos = z;
        }

        public int hashCode() {
            return this.xPos * 43 + this.zPos * 3 + this.dimension;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                if (o instanceof Chunk) {
                    Chunk other = (Chunk)o;
                    return this.xPos == other.field_76635_g && this.zPos == other.field_76647_h && this.dimension == other.func_177412_p().field_73011_w.getDimension();
                }
                return false;
            }
            ChunkReference other = (ChunkReference)o;
            return other.dimension == this.dimension && other.xPos == this.xPos && other.zPos == this.zPos;
        }
    }
}

