/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.IGeneratorParser;
import cofh.lib.world.WorldGenGeode;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class GeodeParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        if (!genObject.hasPath("crust")) {
            log.info("Entry does not specify crust for 'geode' generator. Using stone.");
            list.add(new WeightedRandomBlock(Blocks.field_150348_b));
        } else if (!FeatureParser.parseResList(genObject.root().get((Object)"crust"), list, true)) {
            log.warn("Entry specifies invalid crust for 'geode' generator! Using obsidian!");
            list.clear();
            list.add(new WeightedRandomBlock(Blocks.field_150343_Z));
        }
        WorldGenGeode r = new WorldGenGeode(resList, matList, list);
        if (genObject.hasPath("hollow")) {
            r.setHollow(genObject.getBoolean("hollow"));
        }
        if (genObject.hasPath("filler")) {
            list = new ArrayList();
            if (!FeatureParser.parseResList(genObject.getValue("filler"), list, true)) {
                log.warn("Entry specifies invalid filler for 'geode' generator! Not filling!");
            } else {
                r.setFillBlock(list);
            }
        }
        return r;
    }
}

