/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public final class BlockWrapper {
    public Block block;
    public int metadata;

    public BlockWrapper(IBlockState state) {
        this(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public BlockWrapper(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public BlockWrapper set(Block block, int metadata) {
        if (block != null) {
            this.block = block;
            this.metadata = metadata;
        } else {
            this.block = null;
            this.metadata = 0;
        }
        return this;
    }

    public boolean isEqual(@Nonnull IBlockState state) {
        return this.block == state.func_177230_c() && this.metadata == this.block.func_176201_c(state);
    }

    public boolean isEqual(BlockWrapper other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.block == other.block) {
                return true;
            }
            if (this.block != null && other.block != null) {
                return this.block.delegate.get() == other.block.delegate.get();
            }
        }
        return false;
    }

    final int getId() {
        return Block.func_149682_b((Block)this.block);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockWrapper)) {
            return false;
        }
        return this.isEqual((BlockWrapper)o);
    }

    public int hashCode() {
        return this.metadata | this.getId() << 16;
    }

    public String toString() {
        String b = this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "m:" + this.metadata + ", i:" + (this.block == null ? null : this.block.getClass().getName()) + '@' + System.identityHashCode(this.block) + ", v:" + this.getId() + '}';
        return b;
    }
}

