/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.numbers.world;

import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.util.numbers.world.WorldValueEnum;
import java.util.Locale;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldValueProvider
implements INumberProvider {
    protected final INumberProvider offset;
    protected final WorldValueEnum data;
    protected final long min;
    protected final long max;

    public WorldValueProvider(INumberProvider offset, String type, long min, long max) {
        this.offset = offset;
        this.data = WorldValueEnum.valueOf(type.toUpperCase(Locale.US));
        this.min = min;
        this.max = max;
    }

    protected long getValue(World world, Random rand, BlockPos pos) {
        return this.data.getValue(world, rand, pos);
    }

    @Override
    public int intValue(World world, Random rand, BlockPos pos) {
        return (int)this.longValue(world, rand, pos);
    }

    @Override
    public long longValue(World world, Random rand, BlockPos pos) {
        return Math.min(Math.max(this.getValue(world, rand, pos) + this.offset.longValue(world, rand, pos), this.min), this.max);
    }

    @Override
    public float floatValue(World world, Random rand, BlockPos pos) {
        return (float)this.doubleValue(world, rand, pos);
    }

    @Override
    public double doubleValue(World world, Random rand, BlockPos pos) {
        return Math.min(Math.max((double)this.getValue(world, rand, pos) + this.offset.doubleValue(world, rand, pos), (double)this.min), (double)this.max);
    }
}

