/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSpike
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    public boolean largeSpikes = true;
    public int largeSpikeChance = 60;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int positionVariance = 3;
    public int minLargeSpikeHeightGain = 10;
    public int largeSpikeHeightVariance = 30;
    public int largeSpikeFillerSize = 1;

    public WorldGenSpike(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height;
        int yStart;
        int xStart = pos.func_177958_n();
        int zStart = pos.func_177952_p();
        for (yStart = pos.func_177956_o(); world.func_175623_d(new BlockPos(xStart, yStart, zStart)) && yStart > 2; --yStart) {
        }
        if (!WorldGenMinableCluster.canGenerateInBlock(world, xStart, yStart, zStart, this.genBlock)) {
            return false;
        }
        int originalHeight = height = rand.nextInt(this.heightVariance) + this.minHeight;
        int size = height / (this.minHeight / 2) + rand.nextInt(this.sizeVariance);
        if (size > 1 && this.positionVariance > 0) {
            yStart += rand.nextInt(this.positionVariance + 1) - 1;
        }
        if (this.largeSpikes && size > 1 && (this.largeSpikeChance <= 0 || rand.nextInt(this.largeSpikeChance) == 0)) {
            height += this.minLargeSpikeHeightGain + rand.nextInt(this.largeSpikeHeightVariance);
        }
        int offsetHeight = height - originalHeight;
        for (int y = 0; y < height; ++y) {
            float layerSize = y >= offsetHeight ? (1.0f - (float)(y - offsetHeight) / (float)originalHeight) * (float)size : (float)this.largeSpikeFillerSize;
            int width = MathHelper.func_76123_f((float)layerSize);
            for (int x = -width; x <= width; ++x) {
                float xDist = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -width; z <= width; ++z) {
                    float zDist = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(xDist * xDist + zDist * zDist <= layerSize * layerSize) || (x == -width || x == width || z == -width || z == width) && !(rand.nextFloat() <= 0.75f)) continue;
                    WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                    if (y == 0 || width <= 1) continue;
                    WorldGenMinableCluster.generateBlock(world, xStart + x, yStart - y + offsetHeight, zStart + z, this.genBlock, this.cluster);
                }
            }
        }
        return true;
    }
}

