/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.util.numbers.ConstantProvider;
import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenCave
extends FeatureBase {
    final WorldGenerator worldGen;
    final INumberProvider count;
    final boolean ceiling;

    public FeatureGenCave(String name, WorldGenerator worldGen, boolean ceiling, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        this(name, worldGen, ceiling, new ConstantProvider(count), biomeRes, regen, dimRes);
    }

    public FeatureGenCave(String name, WorldGenerator worldGen, boolean ceiling, INumberProvider count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.ceiling = ceiling;
    }

    @Override
    protected boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        int averageSeaLevel = world.field_73011_w.func_76557_i() + 1;
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            IBlockState state;
            int stopY;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int seaLevel = averageSeaLevel;
            if (seaLevel < 20) {
                seaLevel = world.func_189649_b(x, z);
            }
            int y = stopY = random.nextInt(1 + seaLevel / 2);
            while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < seaLevel) {
            }
            if (y == seaLevel) {
                y = 0;
                while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < stopY) {
                }
                if (y == stopY) continue;
            }
            if (this.ceiling) {
                if (y < stopY) {
                    seaLevel = stopY + 1;
                }
                do {
                    state = world.func_180495_p(new BlockPos(x, ++y, z));
                } while (y < seaLevel && state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)));
                if (y == seaLevel) {
                    continue;
                }
            } else if (state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y - 1, z))) {
                --y;
                while ((state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && y-- > 0) {
                }
                if (y == -1) continue;
            }
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

