/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import mekanism.api.energy.IEnergizedItem;
import net.machinemuse.api.electricity.ElectricAdapter;
import net.minecraft.item.ItemStack;

public class MekanismElectricAdapter
extends ElectricAdapter {
    private final ItemStack stack;
    private final IEnergizedItem item;

    public MekanismElectricAdapter(ItemStack stack) {
        this.stack = stack;
        this.item = (IEnergizedItem)stack.func_77973_b();
    }

    public ItemStack stack() {
        return this.stack;
    }

    public IEnergizedItem item() {
        return this.item;
    }

    @Override
    public double getCurrentMPSEnergy() {
        return this.item().canSend(this.stack()) ? this.item().getEnergy(this.stack()) : 0.0;
    }

    @Override
    public double getMaxMPSEnergy() {
        return this.item().getMaxEnergy(this.stack());
    }

    @Override
    public double drainMPSEnergy(double requested) {
        double available;
        double d = available = this.item().canSend(this.stack()) ? this.item().getEnergy(this.stack()) : 0.0;
        if (available > requested) {
            this.item().setEnergy(this.stack(), available - requested);
            return requested;
        }
        this.item().setEnergy(this.stack(), 0.0);
        return available;
    }

    @Override
    public double giveMPSEnergy(double provided) {
        double max;
        double available = this.item().canSend(this.stack()) ? this.item().getEnergy(this.stack()) : 0.0;
        if (available + provided < (max = this.item().getMaxEnergy(this.stack()))) {
            this.item().setEnergy(this.stack(), available + provided);
            return provided;
        }
        this.item().setEnergy(this.stack(), max);
        return max - available;
    }
}

