/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import ic2.api.item.ElectricItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions;
import net.machinemuse.api.electricity.IMuseElectricItem;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MuseElectricItem
extends Item
implements IMuseElectricItem {
    private static MuseElectricItem INSTANCE;

    public static MuseElectricItem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MuseElectricItem();
        }
        return INSTANCE;
    }

    @Override
    public double getCurrentMPSEnergy(ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, "Current Energy");
    }

    @Override
    public double getMaxMPSEnergy(ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, "Maximum Energy");
    }

    @Override
    public void setCurrentMPSEnergy(ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, "Current Energy", Math.min(energy, this.getMaxMPSEnergy(stack)));
    }

    @Override
    public double drainMPSEnergyFrom(ItemStack stack, double requested) {
        double available = this.getCurrentMPSEnergy(stack);
        if (available > requested) {
            this.setCurrentMPSEnergy(stack, available - requested);
            return requested;
        }
        this.setCurrentMPSEnergy(stack, 0.0);
        return available;
    }

    @Override
    public double giveMPSEnergyTo(ItemStack stack, double provided) {
        double max;
        double available = this.getCurrentMPSEnergy(stack);
        if (available + provided < (max = this.getMaxMPSEnergy(stack))) {
            this.setCurrentMPSEnergy(stack, available + provided);
            return provided;
        }
        this.setCurrentMPSEnergy(stack, max);
        return max - available;
    }

    @Override
    public IMuseElectricItem getManager(ItemStack stack) {
        return this;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        ElectricItem.rawManager.chargeFromArmor(itemStack, entity);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return ElectricItem.rawManager.use(itemStack, ElectricConversions.museEnergyToEU(amount), entity);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getCurrentMPSEnergy(itemStack));
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getMaxMPSEnergy(itemStack));
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return ElectricConversions.getTier(itemStack);
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(Math.sqrt(this.getMaxMPSEnergy(itemStack)));
    }

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = this.getCurrentMPSEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double given = this.giveMPSEnergyTo(itemStack, transfer);
        if (simulate) {
            this.setCurrentMPSEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(given);
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        double current = this.getCurrentMPSEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double taken = this.drainMPSEnergyFrom(itemStack, transfer);
        if (simulate) {
            this.setCurrentMPSEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(taken);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricConversions.museEnergyFromEU(amount) < this.getCurrentMPSEnergy(itemStack);
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        return "";
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public int receiveEnergy(ItemStack stack, int energy, boolean simulate) {
        double current = this.getCurrentMPSEnergy(stack);
        double receivedME = ElectricConversions.museEnergyFromRF(energy);
        double eatenME = this.giveMPSEnergyTo(stack, receivedME);
        if (simulate) {
            this.setCurrentMPSEnergy(stack, current);
        }
        return ElectricConversions.museEnergyToRF(eatenME);
    }

    @Override
    public int extractEnergy(ItemStack stack, int energy, boolean simulate) {
        double current = this.getCurrentMPSEnergy(stack);
        double requesteddME = ElectricConversions.museEnergyFromRF(energy);
        double takenME = this.drainMPSEnergyFrom(stack, requesteddME);
        if (simulate) {
            this.setCurrentMPSEnergy(stack, current);
        }
        return ElectricConversions.museEnergyToRF(takenME);
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return ElectricConversions.museEnergyToRF(this.getCurrentMPSEnergy(theItem));
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return ElectricConversions.museEnergyToRF(this.getMaxMPSEnergy(theItem));
    }

    @Override
    public int getMaxDamage(ItemStack itemStack) {
        return 0;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        return this.getCurrentMPSEnergy(itemStack);
    }

    @Override
    public void setEnergy(ItemStack itemStack, double v) {
        this.giveMPSEnergyTo(itemStack, v);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxMPSEnergy(itemStack);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxMPSEnergy(itemStack);
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }
}

