/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.general.gui.clickable.ClickableButton;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.network.packets.MusePacketToggleRequest;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ClickableKeybinding
extends ClickableButton {
    protected List<ClickableModule> boundModules = new ArrayList<ClickableModule>();
    public boolean toggleval = false;
    boolean toggled = false;
    KeyBinding keybind;
    public boolean displayOnHUD;

    public ClickableKeybinding(KeyBinding keybind, MusePoint2D position, boolean free, Boolean displayOnHUD) {
        super(ClickableKeybinding.parseName(keybind), position, true);
        this.displayOnHUD = displayOnHUD != null ? displayOnHUD : false;
        this.keybind = keybind;
    }

    static String parseName(KeyBinding keybind) {
        if (keybind.func_151463_i() < 0) {
            return "Mouse" + (keybind.func_151463_i() + 100);
        }
        return Keyboard.getKeyName((int)keybind.func_151463_i());
    }

    public void doToggleTick() {
        this.doToggleIf(this.keybind.func_151468_f());
    }

    public void doToggleIf(boolean value) {
        if (value && !this.toggled) {
            this.toggleModules();
            KeybindManager.writeOutKeybinds();
        }
        this.toggled = value;
    }

    public void toggleModules() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ClickableModule module : this.boundModules) {
            String valstring;
            String string = valstring = this.toggleval ? " on" : " off";
            if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT) && Config.toggleModuleSpam()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Toggled " + module.getModule().getDataName() + valstring));
            }
            MuseItemUtils.toggleModuleForPlayer((EntityPlayer)player, module.getModule().getDataName(), this.toggleval);
            MusePacketToggleRequest toggleRequest = new MusePacketToggleRequest((EntityPlayer)player, module.getModule().getDataName(), this.toggleval);
            PacketSender.sendToServer(toggleRequest);
        }
        this.toggleval = !this.toggleval;
    }

    @Override
    public void draw() {
        super.draw();
        for (ClickableModule module : this.boundModules) {
            MuseRenderer.drawLineBetween(this, module, Colour.LIGHTBLUE);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            if (this.displayOnHUD) {
                MuseRenderer.drawString(MuseStringUtils.wrapFormatTags("HUD", MuseStringUtils.FormatCodes.BrightGreen), this.position.x() * 2.0 + 6.0, this.position.y() * 2.0 + 6.0);
            } else {
                MuseRenderer.drawString(MuseStringUtils.wrapFormatTags("x", MuseStringUtils.FormatCodes.Red), this.position.x() * 2.0 + 6.0, this.position.y() * 2.0 + 6.0);
            }
            GL11.glPopMatrix();
        }
    }

    public KeyBinding getKeyBinding() {
        return this.keybind;
    }

    public List<ClickableModule> getBoundModules() {
        return this.boundModules;
    }

    public void bindModule(ClickableModule module) {
        if (!this.boundModules.contains(module)) {
            this.boundModules.add(module);
        }
    }

    public void unbindModule(ClickableModule module) {
        this.boundModules.remove(module);
    }

    public void unbindFarModules() {
        Iterator<ClickableModule> iterator = this.boundModules.iterator();
        while (iterator.hasNext()) {
            ClickableModule module = iterator.next();
            int maxDistance = this.getTargetDistance() * 2;
            double distanceSq = module.getPosition().distanceSq(this.getPosition());
            if (!(distanceSq > (double)(maxDistance * maxDistance))) continue;
            iterator.remove();
        }
    }

    public int getTargetDistance() {
        return this.boundModules.size() > 6 ? 16 + (this.boundModules.size() - 6) * 3 : 16;
    }

    public void attractBoundModules(IClickable exception) {
        for (ClickableModule module : this.boundModules) {
            if (module.equals(exception)) continue;
            MusePoint2D euclideanDistance = module.getPosition().minus(this.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(this.getTargetDistance()).plus(this.getPosition());
            MusePoint2D midpointTangent = module.getPosition().midpoint(tangentTarget);
            module.move(midpointTangent.x(), midpointTangent.y());
        }
    }

    public boolean equals(ClickableKeybinding other) {
        return other.keybind.func_151463_i() == this.keybind.func_151463_i();
    }

    public void toggleHUDState() {
        this.displayOnHUD = !this.displayOnHUD;
    }
}

