/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ILocalizeableModule;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.general.gui.clickable.Clickable;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.render.MuseIconUtils;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.GuiIcons;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.resources.I18n;

public class ClickableModule
extends Clickable {
    boolean allowed = true;
    boolean installed = false;
    final Colour checkmarkcolour = new Colour(0.0, 0.667f, 0.0, 1.0);
    IPowerModule module;

    public ClickableModule(IPowerModule module, MusePoint2D position) {
        super(position);
        this.module = module;
    }

    @Override
    public List<String> getToolTip() {
        ArrayList<String> toolTipText = new ArrayList<String>();
        toolTipText.add(this.getLocalizedName(this.getModule()));
        toolTipText.addAll(MuseStringUtils.wrapStringToLength(this.getLocalizedDescription(this.getModule()), 30));
        return toolTipText;
    }

    public String getLocalizedName(IPowerModule m) {
        if (m instanceof ILocalizeableModule) {
            return I18n.func_135052_a((String)("module." + ((ILocalizeableModule)m).getUnlocalizedName() + ".name"), (Object[])new Object[0]);
        }
        return "module has broken translation for localized name";
    }

    public String getLocalizedDescription(IPowerModule m) {
        if (m instanceof ILocalizeableModule) {
            return I18n.func_135052_a((String)("module." + ((ILocalizeableModule)m).getUnlocalizedName() + ".desc"), (Object[])new Object[0]);
        }
        return "module has broken translation for description";
    }

    @Override
    public void draw() {
        double k = 2.147483647E9;
        double left = this.getPosition().x() - 8.0;
        double top = this.getPosition().y() - 8.0;
        this.drawPartial(left, top, left + 16.0, top + 16.0);
    }

    public void drawPartial(double xmino, double ymino, double xmaxo, double ymaxo) {
        double left = this.getPosition().x() - 8.0;
        double top = this.getPosition().y() - 8.0;
        MuseTextureUtils.pushTexture(this.getModule().getStitchedTexture(null));
        MuseIconUtils.drawIconAt(left, top, this.getModule().getIcon(null), Colour.WHITE);
        MuseTextureUtils.popTexture();
        if (!this.allowed) {
            String string = MuseStringUtils.wrapFormatTags("x", MuseStringUtils.FormatCodes.DarkRed);
            MuseRenderer.drawString(string, this.getPosition().x() + 3.0, this.getPosition().y() + 1.0);
        } else if (this.installed) {
            new GuiIcons.Checkmark(this.getPosition().x() - 8.0 + 1.0, this.getPosition().y() - 8.0 + 1.0, this.checkmarkcolour, null, null, null, null);
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.getPosition().x()) < 8.0;
        boolean hity = Math.abs(y - this.getPosition().y()) < 8.0;
        return hitx && hity;
    }

    public IPowerModule getModule() {
        return this.module;
    }

    public boolean equals(ClickableModule other) {
        return this.module == other.getModule();
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }
}

