/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import net.machinemuse.general.gui.clickable.Clickable;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.utils.render.MuseRenderer;

public class ClickableSlider
extends Clickable {
    double valueInternal = 0.0;
    MusePoint2D pos;
    double width;
    String name;
    DrawableMuseRect insideRect;
    DrawableMuseRect outsideRect;
    final int cornersize = 3;

    public ClickableSlider(MusePoint2D pos, double width, String name) {
        this.pos = pos;
        this.width = width;
        this.name = name;
        this.position = pos;
        this.insideRect = new DrawableMuseRect(this.position.x() - width / 2.0 - 3.0, this.position.y() + 8.0, 0.0, this.position.y() + 16.0, Colour.LIGHTBLUE, Colour.ORANGE);
        this.outsideRect = new DrawableMuseRect(this.position.x() - width / 2.0 - 3.0, this.position.y() + 8.0, this.position.x() + width / 2.0 + 3.0, this.position.y() + 16.0, Colour.LIGHTBLUE, Colour.DARKBLUE);
    }

    public String name() {
        return this.name;
    }

    @Override
    public void draw() {
        MuseRenderer.drawCenteredString(this.name, this.position.x(), this.position.y());
        this.insideRect.setRight(this.position.x() + this.width * (this.value() - 0.5) + 3.0);
        this.outsideRect.draw();
        this.insideRect.draw();
    }

    @Override
    public boolean hitBox(double x, double y) {
        return Math.abs(this.position.x() - x) < this.width / 2.0 && Math.abs(this.position.y() + 12.0 - y) < 4.0;
    }

    public double value() {
        return this.valueInternal;
    }

    public void setValueByX(double x) {
        double v = (x - this.pos.x()) / this.width + 0.5;
        this.valueInternal = MuseMathUtils.clampDouble(v, 0.0, 1.0);
    }

    public void setValue(double v) {
        this.valueInternal = v;
    }
}

