/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.geometry.SpiralPointToPoint2D;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class RadialSelectionFrame
implements IGuiFrame {
    protected List<ClickableModule> modeButtons = new ArrayList<ClickableModule>();
    protected final long spawnTime = System.currentTimeMillis();
    protected int selectedModule = -1;
    protected EntityPlayer player;
    protected MusePoint2D center;
    protected double radius;
    protected ItemStack stack;

    public RadialSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, EntityPlayer player) {
        this.player = player;
        this.center = bottomright.plus(topleft).times(0.5);
        this.radius = Math.min(this.center.minus(topleft).x(), this.center.minus(topleft).y());
        this.stack = player.field_71071_by.func_70448_g();
        this.loadItems();
        if (this.stack != null && this.stack.func_77973_b() instanceof IModeChangingItem && this.modeButtons != null) {
            int i = 0;
            for (ClickableModule mode : this.modeButtons) {
                if (mode.getModule().getDataName().equals(((IModeChangingItem)this.stack.func_77973_b()).getActiveMode(this.stack))) {
                    this.selectedModule = i;
                    break;
                }
                ++i;
            }
        }
    }

    public boolean alreadyAdded(IRightClickModule module) {
        for (ClickableModule clickie : this.modeButtons) {
            if (!clickie.getModule().getDataName().equals(module.getDataName())) continue;
            return true;
        }
        return false;
    }

    private void loadItems() {
        if (this.player != null) {
            ArrayList<IRightClickModule> modes = new ArrayList<IRightClickModule>();
            for (IRightClickModule module : ModuleManager.getRightClickModules()) {
                if (!module.isValidForItem(this.stack) || !ModuleManager.itemHasModule(this.stack, module.getDataName())) continue;
                modes.add(module);
            }
            int modeNum = 0;
            for (IRightClickModule module : modes) {
                if (this.alreadyAdded(module)) continue;
                ClickableModule clickie = new ClickableModule(module, new SpiralPointToPoint2D(this.center, this.radius, 4.71238898038469 - Math.PI * 2 * (double)modeNum / (double)modes.size(), 250.0));
                this.modeButtons.add(clickie);
                ++modeNum;
            }
        }
    }

    private void selectModule(double x, double y) {
        if (this.modeButtons != null) {
            int i = 0;
            for (ClickableModule module : this.modeButtons) {
                if (module.hitBox(x, y)) {
                    this.selectedModule = i;
                    break;
                }
                ++i;
            }
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.modeButtons.size() > this.selectedModule && this.selectedModule != -1) {
            return this.modeButtons.get(this.selectedModule);
        }
        return null;
    }

    @Override
    public void update(double mousex, double mousey) {
        this.loadItems();
        if (System.currentTimeMillis() - this.spawnTime > 250L) {
            this.selectModule(mousex, mousey);
        }
        if (this.getSelectedModule() != null && this.stack != null && this.stack.func_77973_b() instanceof IModeChangingItem) {
            ((IModeChangingItem)this.stack.func_77973_b()).setActiveMode(this.stack, this.getSelectedModule().getModule().getDataName());
            PacketSender.sendToServer(new MusePacketModeChangeRequest(this.player, this.getSelectedModule().getModule().getDataName(), this.player.field_71071_by.field_70461_c));
        }
    }

    private void drawSelection() {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MusePoint2D pos = module.getPosition();
            MuseRenderer.drawCircleAround(pos.x(), pos.y(), 10.0);
        }
    }

    @Override
    public void draw() {
        for (ClickableModule mode : this.modeButtons) {
            mode.draw();
        }
        this.drawSelection();
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

