/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.geometry;

import net.machinemuse.numina.geometry.MusePoint2D;

public class FlyFromPointToPoint2D
extends MusePoint2D {
    protected final MusePoint2D prev;
    protected final long spawnTime;
    protected final double timeTo;

    public FlyFromPointToPoint2D(double x, double y, double x2, double y2, double timeTo) {
        super(x2, y2);
        this.prev = new MusePoint2D(x, y);
        this.spawnTime = System.currentTimeMillis();
        this.timeTo = timeTo;
    }

    public FlyFromPointToPoint2D(MusePoint2D prev, MusePoint2D target, double timeTo) {
        this(prev.x(), prev.y(), target.x(), target.y(), timeTo);
    }

    @Override
    public double x() {
        return this.doRatio(this.prev.x, this.x);
    }

    @Override
    public double y() {
        return this.doRatio(this.prev.y, this.y);
    }

    public double doRatio(double val1, double val2) {
        long elapsed = System.currentTimeMillis() - this.spawnTime;
        double ratio = (double)elapsed / this.timeTo;
        if (ratio > 1.0) {
            return val2;
        }
        return val2 * ratio + val1 * (1.0 - ratio);
    }
}

