/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.geometry;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import org.lwjgl.BufferUtils;

public class GradientAndArcCalculator {
    public static DoubleBuffer getArcPoints(double startangle, double endangle, double radius, double xoffset, double yoffset, double zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((endangle - startangle) * 2.0 * Math.PI));
        double theta = (endangle - startangle) / (double)numVertices;
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numVertices * 3));
        double x = radius * Math.sin(startangle);
        double y = radius * Math.cos(startangle);
        double tf = Math.tan(theta);
        double rf = Math.cos(theta);
        for (int i = 0; i < numVertices; ++i) {
            buffer.put(x + xoffset);
            buffer.put(y + yoffset);
            buffer.put(zoffset);
            double tx = y;
            double ty = -x;
            x += tx * tf;
            y += ty * tf;
            x *= rf;
            y *= rf;
        }
        buffer.flip();
        return buffer;
    }

    public static List<MusePoint2D> pointsInLine(int num, MusePoint2D a, MusePoint2D b) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        switch (num) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                points.add(b.minus(a).times(0.5).plus(a));
                break;
            }
            default: {
                MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
                for (int i = 0; i < num; ++i) {
                    points.add(a.plus(step.times(i + 1)));
                }
            }
        }
        return points;
    }

    public static DoubleBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numsegments * 4));
        for (double i = 0.0; i < (double)numsegments; i += 1.0) {
            Colour c3 = c1.interpolate(c2, i / (double)numsegments);
            buffer.put(c3.r);
            buffer.put(c3.g);
            buffer.put(c3.b);
            buffer.put(c3.a);
        }
        buffer.flip();
        return buffer;
    }
}

