/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.item.NuminaItemUtils;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.network.PacketSender;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModeChangingItem
implements IModeChangingItem {
    private static Item mcItem;

    public ModeChangingItem(ItemStack mcitemStack) {
        ItemStack mcitemStack1 = mcitemStack;
        mcItem = mcitemStack != null && mcitemStack.func_77973_b() instanceof IModeChangingItem ? mcitemStack.func_77973_b() : null;
    }

    public ModeChangingItem(Item mcItem) {
        ModeChangingItem.mcItem = mcItem != null && mcItem instanceof IModeChangingItem ? mcItem : null;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getModeIcon(String mode, ItemStack stack, EntityPlayer player) {
        if (mcItem != null) {
            return ((IModeChangingItem)mcItem).getModeIcon(mode, stack, player);
        }
        return null;
    }

    @Override
    public List<String> getValidModes(ItemStack stack) {
        ArrayList<String> modes = new ArrayList<String>();
        if (mcItem != null) {
            return ((IModeChangingItem)mcItem).getValidModes(stack);
        }
        return modes;
    }

    @Override
    public String getActiveMode(ItemStack stack) {
        String modeFromNBT = NuminaItemUtils.getTagCompound(stack).func_74779_i("mode");
        if (modeFromNBT.isEmpty()) {
            List<String> validModes = this.getValidModes(stack);
            return validModes != null && validModes.size() > 0 ? validModes.get(0) : "";
        }
        return modeFromNBT;
    }

    @Override
    public void setActiveMode(ItemStack stack, String newMode) {
        NuminaItemUtils.getTagCompound(stack).func_74778_a("mode", newMode);
    }

    @Override
    public void cycleMode(ItemStack stack, EntityPlayer player, int dMode) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = ModeChangingItem.clampMode(modes.indexOf(this.getActiveMode(stack)) + dMode, modes.size());
            String newmode = modes.get(newindex);
            this.setActiveMode(stack, newmode);
            PacketSender.sendToServer(new MusePacketModeChangeRequest(player, newmode, player.field_71071_by.field_70461_c));
        }
    }

    private static int clampMode(int selection, int modesSize) {
        return selection > 0 ? selection % modesSize : (selection + modesSize * -selection) % modesSize;
    }

    @Override
    public String nextMode(ItemStack stack, EntityPlayer player) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = ModeChangingItem.clampMode(modes.indexOf(this.getActiveMode(stack)) + 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }

    @Override
    public String prevMode(ItemStack stack, EntityPlayer player) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = ModeChangingItem.clampMode(modes.indexOf(this.getActiveMode(stack)) - 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }
}

