/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.SimpleItemMaker;
import net.machinemuse.numina.recipe.SimpleItemMatcher;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class JSONRecipe
implements IRecipe {
    public SimpleItemMatcher[][] ingredients;
    public SimpleItemMaker result;
    public Boolean mirror;
    public Boolean unshaped;
    private boolean isValid = true;
    static final int MAX_WIDTH = 3;
    static final int MAX_HEIGHT = 3;

    public boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void validate() {
        ArrayList inputs = new ArrayList();
        int height = this.ingredients.length;
        int width = this.getWidth();
        if (height == 0 || width == 0) {
            this.isValid = false;
            return;
        }
        if (this.result == null) {
            this.isValid = false;
            return;
        }
        for (int y = 0; y < height; ++y) {
            if (this.ingredients[y] == null) continue;
            for (int x = 0; x < width; ++x) {
                List<Object> itemStacks = new ArrayList();
                if (this.ingredients[y].length > x) {
                    itemStacks = this.getIngredient(this.ingredients[y][x]);
                }
                if (itemStacks == null || !itemStacks.isEmpty()) continue;
                this.isValid = false;
            }
        }
    }

    public ItemStack func_77571_b() {
        if (this.result.getRecipeOutput() == null) {
            this.setIsValid(false);
        }
        return this.result.getRecipeOutput();
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        int width = this.getWidth();
        int height = this.ingredients.length;
        for (int xoffset = 0; xoffset <= 3 - width; ++xoffset) {
            for (int yoffset = 0; yoffset <= 3 - height; ++yoffset) {
                if (this.matchSpot(inv, xoffset, yoffset, width, height, false)) {
                    return true;
                }
                if (this.mirror == null || !this.mirror.booleanValue() || !this.matchSpot(inv, xoffset, yoffset, width, height, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchSpot(InventoryCrafting inv, int xoffset, int yoffset, int width, int height, boolean mirror) {
        boolean mismatch = false;
        for (int xinventory = 0; xinventory < 3; ++xinventory) {
            for (int yinventory = 0; yinventory < 3; ++yinventory) {
                SimpleItemMatcher matcher = !mirror ? this.getMatcher(-xoffset + xinventory, -yoffset + yinventory) : this.getMatcher(-xoffset + width - xinventory - 1, -yoffset + yinventory);
                if (matcher != null && !matcher.matchesItem(this.getInvStack(inv, xinventory, yinventory))) {
                    mismatch = true;
                }
                if (matcher != null || this.getInvStack(inv, xinventory, yinventory) == null) continue;
                mismatch = true;
            }
        }
        return !mismatch;
    }

    private ItemStack getInvStack(InventoryCrafting inv, int x, int y) {
        if (x < 0 || y < 0) {
            return null;
        }
        return inv.func_70463_b(x, y);
    }

    public SimpleItemMatcher getMatcher(int x, int y) {
        if (y >= 0 && y < this.ingredients.length && x >= 0 && x < this.ingredients[y].length) {
            return this.ingredients[y][x];
        }
        return null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.result.makeItem(inventoryCrafting);
    }

    public int func_77570_a() {
        if (this.ingredients == null) {
            return 0;
        }
        int size = 0;
        for (SimpleItemMatcher[] row : this.ingredients) {
            if (row == null) continue;
            for (SimpleItemMatcher cell : row) {
                if (cell == null) continue;
                ++size;
            }
        }
        return size;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] aitemstack = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    public int getWidth() {
        int size = 0;
        for (SimpleItemMatcher[] row : this.ingredients) {
            if (row == null) continue;
            size = Math.max(row.length, size);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JSONRecipe)) {
            return false;
        }
        JSONRecipe other = (JSONRecipe)obj;
        if (this.ingredients.length != other.ingredients.length) {
            return false;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i].length != other.ingredients[i].length) {
                return false;
            }
            for (int j = 0; j < this.ingredients[i].length; ++j) {
                if (this.compareIngredients(this.ingredients[i][j], other.ingredients[i][j])) continue;
                return false;
            }
        }
        if (!this.compareResult(this.result, other.result)) {
            return false;
        }
        return this.compareBoolean(this.mirror, other.mirror);
    }

    private boolean compareResult(SimpleItemMaker a, SimpleItemMaker b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    private boolean compareIngredients(SimpleItemMatcher a, SimpleItemMatcher b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    private boolean compareBoolean(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.booleanValue() == b.booleanValue();
    }

    public List<ItemStack> getIngredient(SimpleItemMatcher cell) {
        ArrayList<ItemStack> t;
        Boolean shouldbenull = true;
        ArrayList<Object> result = null;
        if (cell == null) {
            return null;
        }
        if (cell.oredictName != null) {
            shouldbenull = false;
            result = OreDictionary.getOres((String)cell.oredictName);
            if (cell.meta != null && result != null && cell.meta != Short.MAX_VALUE) {
                t = new ArrayList();
                for (ItemStack itemStack : result) {
                    if (cell.meta.intValue() != itemStack.func_77952_i()) continue;
                    t.add(itemStack);
                }
                result = t;
            }
        }
        if (cell.itemStackName != null) {
            shouldbenull = false;
            result = new ArrayList<ItemStack>();
            ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(cell.itemStackName)), 1);
            if (stack != null) {
                stack = stack.func_77946_l();
                if (cell.meta != null) {
                    stack.func_77964_b(cell.meta.intValue());
                }
                result.add(stack);
            }
        }
        if (cell.registryName != null) {
            shouldbenull = false;
            result = new ArrayList();
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(cell.registryName));
            if (item != null) {
                int newMeta = cell.meta == null ? 0 : cell.meta;
                ItemStack itemStack = new ItemStack(item, 1, newMeta);
                result.add(itemStack);
            }
        }
        if (cell.nbtString != null && result != null) {
            shouldbenull = false;
            t = new ArrayList<ItemStack>();
            for (ItemStack itemStack : result) {
                ItemStack stack2 = itemStack.func_77946_l();
                try {
                    stack2.func_77982_d(JsonToNBT.func_180713_a((String)cell.nbtString));
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                t.add(stack2);
            }
            result = t;
        }
        if (!(shouldbenull.booleanValue() || result != null && result.size() != 0)) {
            this.isValid = false;
            MuseLogger.logError("cell should not be null but it is");
            MuseLogger.logError("cell.oredictName: " + cell.oredictName);
            MuseLogger.logError("cell.itemStackName: " + cell.itemStackName);
            MuseLogger.logError("cell.registryName: " + cell.registryName);
            MuseLogger.logError("cell.nbtString: " + cell.nbtString);
        }
        return result;
    }
}

