/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.IItemMaker;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleItemMaker
implements IItemMaker {
    public Integer meta;
    public Integer quantity;
    public String oredictName;
    public String registryName;
    public String itemStackName;
    public String nbtString;

    @Override
    public ItemStack makeItem(InventoryCrafting i) {
        return this.getRecipeOutput();
    }

    private int getOrElse(Integer input, int defaultval) {
        if (input == null) {
            return defaultval;
        }
        return input;
    }

    @Override
    public ItemStack getRecipeOutput() {
        int newmeta = this.getOrElse(this.meta, 0);
        int newquantity = this.getOrElse(this.quantity, 1);
        NBTTagCompound nbt = null;
        if (this.nbtString != null) {
            try {
                nbt = JsonToNBT.func_180713_a((String)this.nbtString);
            }
            catch (Exception e) {
                MuseLogger.logException("Bad NBT string in item! Attempting to create generic item instead.", e);
            }
        }
        if (this.itemStackName != null) {
            MuseLogger.logDebug("ItemStack name is: " + this.itemStackName);
            try {
                ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.itemStackName)), newquantity);
                if (this.meta != null) {
                    stack.func_77964_b(this.meta.intValue());
                }
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.itemStackName + " from Item Registry");
                return null;
            }
        }
        if (this.registryName != null) {
            String[] names = this.registryName.split(":");
            MuseLogger.logDebug("registry name is: " + this.registryName);
            try {
                ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(names[0], names[1])), newquantity, newmeta);
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.registryName + " from Item Registry");
                return null;
            }
        }
        if (this.oredictName != null) {
            MuseLogger.logDebug("oredict name is: " + this.oredictName);
            try {
                ItemStack stack = ((ItemStack)OreDictionary.getOres((String)this.oredictName).get(0)).func_77946_l();
                stack.field_77994_a = Math.min(newquantity, stack.func_77976_d());
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.oredictName + " from oredict");
                return null;
            }
        }
        MuseLogger.logError("Could not find a valid item for recipe output so returning NULL \n this will invalidate the recipe");
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleItemMaker)) {
            return false;
        }
        SimpleItemMaker other = (SimpleItemMaker)obj;
        if (!this.compareInteger(this.meta, other.meta)) {
            return false;
        }
        if (!this.compareInteger(this.quantity, other.quantity)) {
            return false;
        }
        if (!this.compareString(this.oredictName, other.oredictName)) {
            return false;
        }
        if (!this.compareString(this.registryName, other.registryName)) {
            return false;
        }
        if (!this.compareString(this.itemStackName, other.itemStackName)) {
            return false;
        }
        return this.compareString(this.nbtString, other.nbtString);
    }

    private boolean compareInteger(Integer a, Integer b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.intValue() == b.intValue();
    }

    private boolean compareString(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }
}

