/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.render;

import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.render.RenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class MuseIconUtils {
    public static void drawIconAt(double x, double y, TextureAtlasSprite icon, Colour colour) {
        MuseIconUtils.drawIconPartial(x, y, icon, colour, 0.0, 0.0, 16.0, 16.0);
    }

    public static void drawIconPartialOccluded(double x, double y, TextureAtlasSprite icon, Colour colour, double left, double top, double right, double bottom) {
        double xmin = MuseMathUtils.clampDouble(left - x, 0.0, 16.0);
        double ymin = MuseMathUtils.clampDouble(top - y, 0.0, 16.0);
        double xmax = MuseMathUtils.clampDouble(right - x, 0.0, 16.0);
        double ymax = MuseMathUtils.clampDouble(bottom - y, 0.0, 16.0);
        MuseIconUtils.drawIconPartial(x, y, icon, colour, xmin, ymin, xmax, ymax);
    }

    public static void drawIconPartial(double x, double y, TextureAtlasSprite icon, Colour colour, double left, double top, double right, double bottom) {
        TextureAtlasSprite icon1 = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        if (icon != null) {
            icon1 = icon;
        }
        GL11.glPushMatrix();
        RenderState.on2D();
        RenderState.blendingOn();
        if (colour != null) {
            colour.doGL();
        }
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tess.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float u1 = icon1.func_94209_e();
        float v1 = icon1.func_94206_g();
        float u2 = icon1.func_94212_f();
        float v2 = icon1.func_94210_h();
        double xoffset1 = left * (double)(u2 - u1) / 16.0;
        double yoffset1 = top * (double)(v2 - v1) / 16.0;
        double xoffset2 = right * (double)(u2 - u1) / 16.0;
        double yoffset2 = bottom * (double)(v2 - v1) / 16.0;
        vertexBuffer.func_181662_b(x + left, y + top, 0.0);
        vertexBuffer.func_187315_a((double)u1 + xoffset1, (double)v1 + yoffset1);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_181662_b(x + left, y + bottom, 0.0);
        vertexBuffer.func_187315_a((double)u1 + xoffset1, (double)v1 + yoffset2);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_181662_b(x + right, y + bottom, 0.0);
        vertexBuffer.func_187315_a((double)u1 + xoffset2, (double)v1 + yoffset2);
        vertexBuffer.func_181675_d();
        vertexBuffer.func_181662_b(x + right, y + top, 0.0);
        vertexBuffer.func_187315_a((double)u1 + xoffset2, (double)v1 + yoffset1);
        vertexBuffer.func_181675_d();
        tess.func_78381_a();
        RenderState.blendingOff();
        RenderState.off2D();
        GL11.glPopMatrix();
    }
}

