/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.sound;

import java.util.HashMap;
import net.machinemuse.numina.common.NuminaConfig;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.sound.MovingSoundPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Musique {
    @SideOnly(value=Side.CLIENT)
    private static HashMap<SoundEvent, MovingSoundPlayer> soundMap = new HashMap();

    @SideOnly(value=Side.CLIENT)
    public static SoundHandler mcsound() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public GameSettings options() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    public static void playClientSound(SoundEvent soundEvt, SoundCategory categoryIn, float volumeIn, BlockPos posIn) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            BlockPos pos = posIn != null ? posIn : Minecraft.func_71410_x().field_71439_g.func_180425_c();
            PositionedSoundRecord sound = new PositionedSoundRecord(soundEvt, categoryIn, volumeIn, 1.0f, pos);
            Musique.mcsound().func_147682_a((ISound)sound);
        }
    }

    public static String makeSoundString(EntityPlayer player, String soundname) {
        String soundprefix = "Numina";
        return soundprefix + player.func_174793_f().func_70005_c_() + soundname;
    }

    public static void playerSound(EntityPlayer player, SoundEvent soundEvt, SoundCategory categoryIn, float volume, Float pitch, Boolean continuous) {
        pitch = Float.valueOf(pitch != null ? pitch.floatValue() : 1.0f);
        continuous = continuous != null ? continuous : true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            MovingSoundPlayer sound = soundMap.get(soundEvt);
            if (sound != null && (sound.func_147667_k() || !sound.func_147657_c())) {
                Musique.stopPlayerSound(player, soundEvt);
                sound = null;
            }
            if (sound != null) {
                sound.updateVolume(volume).updatePitch(pitch.floatValue()).updateRepeat(continuous);
            } else {
                MuseLogger.logDebug("New sound: " + soundEvt.func_187503_a());
                MovingSoundPlayer newsound = new MovingSoundPlayer(soundEvt, categoryIn, player, volume * 2.0f, pitch.floatValue(), continuous);
                Musique.mcsound().func_147682_a((ISound)newsound);
                soundMap.put(soundEvt, newsound);
            }
        }
    }

    public static void stopPlayerSound(EntityPlayer player, SoundEvent soundEvt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            MovingSoundPlayer sound = soundMap.get(soundEvt);
            MuseLogger.logDebug("Sound stopped: " + soundEvt.func_187503_a());
            if (sound != null) {
                sound.stopPlaying();
                Musique.mcsound().func_147683_b((ISound)sound);
            }
            soundMap.remove(soundEvt);
        }
    }
}

