/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.machinemuse.powersuits.item.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ArmorIcon
implements IBakedModel,
IPerspectiveAwareModel {
    ItemCameraTransforms.TransformType cameraTransformType;
    ItemStack itemStack;
    Item item;
    Colour colour;
    World world;
    EntityLivingBase entity;
    static IBakedModel headIconModel;
    static IBakedModel chestIconModel;
    static IBakedModel legsIconModel;
    static IBakedModel feetIconModel;
    static LoadingCache<Colour, List<BakedQuad>> armorHeadIconCache;
    static LoadingCache<Colour, List<BakedQuad>> armorChestIconCache;
    static LoadingCache<Colour, List<BakedQuad>> armorLegsIconCache;
    static LoadingCache<Colour, List<BakedQuad>> armorFeetIconCache;

    public ArmorIcon(IBakedModel headIconModelIn, IBakedModel chestIconModelIn, IBakedModel legsIconModelIn, IBakedModel feetIconModelIn) {
        if (headIconModelIn instanceof ArmorIcon) {
            ArmorIcon cfr_ignored_0 = (ArmorIcon)headIconModelIn;
        } else {
            headIconModel = headIconModelIn;
        }
        if (chestIconModelIn instanceof ArmorIcon) {
            ArmorIcon cfr_ignored_1 = (ArmorIcon)chestIconModelIn;
        } else {
            chestIconModel = chestIconModelIn;
        }
        if (legsIconModelIn instanceof ArmorIcon) {
            ArmorIcon cfr_ignored_2 = (ArmorIcon)legsIconModelIn;
        } else {
            legsIconModel = legsIconModelIn;
        }
        if (feetIconModelIn instanceof ArmorIcon) {
            ArmorIcon cfr_ignored_3 = (ArmorIcon)feetIconModelIn;
        } else {
            feetIconModel = feetIconModelIn;
        }
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformTypeIn) {
        Matrix4f matrix = headIconModel != null && headIconModel instanceof IPerspectiveAwareModel ? (Matrix4f)((IPerspectiveAwareModel)headIconModel).handlePerspective(cameraTransformTypeIn).getValue() : TRSRTransformation.identity().getMatrix();
        return Pair.of((Object)this, (Object)matrix);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            try {
                if (this.item instanceof ItemPowerArmorHelmet) {
                    return (List)armorHeadIconCache.get((Object)this.colour);
                }
                if (this.item instanceof ItemPowerArmorChestplate) {
                    return (List)armorChestIconCache.get((Object)this.colour);
                }
                if (this.item instanceof ItemPowerArmorLeggings) {
                    return (List)armorLegsIconCache.get((Object)this.colour);
                }
                if (this.item instanceof ItemPowerArmorBoots) {
                    return (List)armorFeetIconCache.get((Object)this.colour);
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean func_177555_b() {
        return headIconModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return headIconModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return headIconModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return headIconModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ArmorIconItemOverrideList();
    }

    static {
        armorHeadIconCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(headIconModel.func_188616_a(null, null, 0L), colour);
            }
        });
        armorChestIconCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(chestIconModel.func_188616_a(null, null, 0L), colour);
            }
        });
        armorLegsIconCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(legsIconModel.func_188616_a(null, null, 0L), colour);
            }
        });
        armorFeetIconCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(feetIconModel.func_188616_a(null, null, 0L), colour);
            }
        });
    }

    public class ArmorIconItemOverrideList
    extends ItemOverrideList {
        public ArmorIconItemOverrideList() {
            super(Collections.EMPTY_LIST);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stackIn, World worldIn, EntityLivingBase entityIn) {
            ArmorIcon.this.itemStack = stackIn;
            ArmorIcon.this.world = worldIn;
            ArmorIcon.this.entity = entityIn;
            ArmorIcon.this.item = ArmorIcon.this.itemStack.func_77973_b();
            ArmorIcon.this.colour = ((IModularItemBase)ArmorIcon.this.item).getColorFromItemStack(ArmorIcon.this.itemStack);
            return originalModel;
        }
    }
}

