/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LuxCapModelHelper {
    private static LuxCapModelHelper ourInstance = new LuxCapModelHelper();
    public static final ModelResourceLocation luxCapItemLocation = new ModelResourceLocation(MPSItems.luxCapacitor.getRegistryName(), "inventory");
    private static final ResourceLocation lensModelLocation = new ResourceLocation("powersuits".toLowerCase(), "models/block/luxCapacitor/lightCore.obj");
    private static List<BakedQuad> itemQuads = new ArrayList<BakedQuad>();
    private static Map<EnumFacing, IBakedModel> luxCapCleanFrameModelMap = new HashMap<EnumFacing, IBakedModel>();
    private static Map<EnumFacing, IBakedModel> luxCapCleanLensModelMap = new HashMap<EnumFacing, IBakedModel>();
    private static Map<Map<Colour, EnumFacing>, List<BakedQuad>> luxCapColoredQuadMap = new HashMap<Map<Colour, EnumFacing>, List<BakedQuad>>();

    public static LuxCapModelHelper getInstance() {
        return ourInstance;
    }

    private LuxCapModelHelper() {
    }

    static IModel getLensModel() {
        IModel model = null;
        try {
            model = OBJLoader.INSTANCE.loadModel(lensModelLocation);
            model = ((OBJModel)model).process(ImmutableMap.copyOf((Map)ImmutableMap.of((Object)"flip-v", (Object)"true")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static IBakedModel getBakedLensModelForFacing(EnumFacing facing) {
        IModel model;
        IBakedModel frameModel;
        IBakedModel lensModel = luxCapCleanLensModelMap.get(facing);
        if (lensModel == null && (frameModel = luxCapCleanFrameModelMap.get(facing)) != null && frameModel instanceof OBJModel.OBJBakedModel && (model = LuxCapModelHelper.getLensModel()) instanceof OBJModel) {
            lensModel = model.bake(((OBJModel.OBJBakedModel)frameModel).getState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        return lensModel;
    }

    public static IBakedModel getFrameForFacing(EnumFacing facing) {
        return luxCapCleanFrameModelMap.get(facing);
    }

    public static void putLuxCapModels(EnumFacing facing, IBakedModel model) {
        if (model instanceof OBJModel.OBJBakedModel && luxCapCleanFrameModelMap.get(facing) == null) {
            luxCapCleanFrameModelMap.put(facing, model);
            IBakedModel lensModel = LuxCapModelHelper.getBakedLensModelForFacing(facing);
            if (lensModel instanceof OBJModel.OBJBakedModel && luxCapCleanLensModelMap.get(facing) == null) {
                luxCapCleanLensModelMap.put(facing, lensModel);
            }
        }
    }

    public ModelResourceLocation getLocationForFacing(EnumFacing facing) {
        if (facing == null) {
            return luxCapItemLocation;
        }
        return new ModelResourceLocation(MPSItems.luxCapacitor.getRegistryName(), "facing=" + facing.func_176610_l());
    }

    public static Colour getColorFromState(IExtendedBlockState state) {
        Colour color = state == null ? BlockLuxCapacitor.defaultColor : (Colour)state.getValue(BlockLuxCapacitor.COLOR);
        color = color != null ? color : BlockLuxCapacitor.defaultColor;
        return color;
    }

    public static EnumFacing getFacingFromState(IBlockState state) {
        if (state == null) {
            return null;
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
    }

    public static List<BakedQuad> getQuadsForColorAndFacing(Colour color, EnumFacing facing) {
        if (facing == null) {
            List<BakedQuad> quadList = itemQuads;
            if (quadList.isEmpty()) {
                ImmutableList quads;
                IBakedModel lensModel = LuxCapModelHelper.getBakedLensModelForFacing(null);
                IBakedModel frameModel = LuxCapModelHelper.getFrameForFacing(null);
                IBlockState state = MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.DOWN);
                List<BakedQuad> lensList = lensModel.func_188616_a(state, null, 0L);
                lensList = ModelHelper.getColoredQuads(lensList, color);
                List frameList = frameModel.func_188616_a(state, null, 0L);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : frameList) {
                    builder.add((Object)quad);
                }
                for (BakedQuad quad : lensList) {
                    builder.add((Object)quad);
                }
                itemQuads = quads = builder.build();
            }
            return itemQuads;
        }
        ImmutableList quadList = luxCapColoredQuadMap.get(ImmutableMap.of((Object)color, (Object)facing));
        if (quadList == null) {
            for (EnumFacing side : EnumFacing.values()) {
                IBakedModel lensModel = LuxCapModelHelper.getBakedLensModelForFacing(side);
                IBakedModel frameModel = LuxCapModelHelper.getFrameForFacing(side);
                IBlockState state = MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)side);
                List<BakedQuad> lensList = lensModel.func_188616_a(state, null, 0L);
                lensList = ModelHelper.getColoredQuads(lensList, color);
                List frameList = frameModel.func_188616_a(state, null, 0L);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : frameList) {
                    builder.add((Object)quad);
                }
                for (BakedQuad quad : lensList) {
                    builder.add((Object)quad);
                }
                ImmutableList quads = builder.build();
                if (facing == side) {
                    quadList = quads;
                }
                luxCapColoredQuadMap.put((Map<Colour, EnumFacing>)ImmutableMap.of((Object)color, (Object)side), (List<BakedQuad>)quads);
            }
        }
        return quadList;
    }

    public static List<BakedQuad> getQuads(IExtendedBlockState state) {
        EnumFacing facing = LuxCapModelHelper.getFacingFromState((IBlockState)state);
        Colour color = LuxCapModelHelper.getColorFromState(state);
        return LuxCapModelHelper.getQuadsForColorAndFacing(color, facing);
    }

    public static TextureAtlasSprite getParticleTexture() {
        return Minecraft.func_71410_x().func_147117_R().func_174942_a(new ResourceLocation(Config.RESOURCE_DOMAIN, "blocks/LuxCap"));
    }
}

