/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.model;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public enum MPSOBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, OBJModel> cache = new HashMap<ResourceLocation, OBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log((Level)Level.INFO, (String)"MPSOBJLoader: Domain %s has been added.", (Object[])new Object[]{domain.toLowerCase()});
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    @Nullable
    private IModel loadModelWithoutCaching(ResourceLocation modelLocation) throws Exception {
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        OBJModel model = null;
        IResource resource = null;
        try {
            resource = this.manager.func_110536_a(file);
        }
        catch (FileNotFoundException e) {
            if (modelLocation.func_110623_a().startsWith("models/block/")) {
                resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
            }
            if (modelLocation.func_110623_a().startsWith("models/item/")) {
                resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
            }
            throw e;
        }
        OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
        try {
            model = parser.parse();
        }
        catch (Exception e) {
            this.errors.put(modelLocation, e);
        }
        return model;
    }

    public void registerModelSprites(ResourceLocation modelLocation) throws Exception {
        try {
            OBJModel model = (OBJModel)this.loadModelWithoutCaching(modelLocation);
            if (model != null) {
                Collection spriteList = model.getTextures();
                for (ResourceLocation spriteLocation : spriteList) {
                    Minecraft.func_71410_x().func_147117_R().func_174942_a(spriteLocation);
                }
            }
        }
        catch (Exception e) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + modelLocation, (Throwable)this.errors.get(modelLocation));
        }
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        OBJModel model = null;
        if (!this.cache.containsKey(file)) {
            model = (OBJModel)this.loadModelWithoutCaching(file);
            if (model != null) {
                this.cache.put(file, model);
            } else {
                throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, (Throwable)this.errors.get(modelLocation));
            }
        }
        return model;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }
}

