/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.model.MPSOBJLoader;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpecXMLReader;
import net.machinemuse.powersuits.common.Config;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ModelHelper {
    public static final ResourceLocation powerFistLocation;
    public static final ResourceLocation powerFistFiringLocation;
    public static final ResourceLocation powerFistLeftLocation;
    public static final ResourceLocation powerFistLeftFiringLocation;
    static IBakedModel powerFist;
    static IBakedModel powerFistFiring;
    static IBakedModel powerFistLeft;
    static IBakedModel powerFistLeftFiring;
    public static int xtap;
    public static int ytap;
    public static int ztap;
    public static float xOffest;
    public static float yOffest;
    public static float zOffest;
    public static float scalemodifier;
    public static boolean tap;

    public static void loadArmorModels(boolean loadModels) {
        URL resource = ModelHelper.class.getResource("/assets/powersuits/models/item/armor/modelspec.xml");
        ModelSpecXMLReader.getINSTANCE().parseFile(resource, loadModels);
        URL otherResource = ModelHelper.class.getResource("/assets/powersuits/models/item/armor/armor2.xml");
        ModelSpecXMLReader.getINSTANCE().parseFile(otherResource, loadModels);
        if (!loadModels) {
            try {
                MPSOBJLoader.INSTANCE.registerModelSprites(powerFistLocation);
                MPSOBJLoader.INSTANCE.registerModelSprites(powerFistFiringLocation);
                MPSOBJLoader.INSTANCE.registerModelSprites(powerFistLeftLocation);
                MPSOBJLoader.INSTANCE.registerModelSprites(powerFistLeftFiringLocation);
            }
            catch (Exception exception) {}
        } else {
            powerFist = ModelHelper.loadBakedModel(powerFistLocation);
            powerFistFiring = ModelHelper.loadBakedModel(powerFistFiringLocation);
            powerFistLeft = ModelHelper.loadBakedModel(powerFistLeftLocation);
            powerFistLeftFiring = ModelHelper.loadBakedModel(powerFistLeftFiringLocation);
        }
    }

    public static IModel getModel(ResourceLocation resource) {
        OBJModel model = null;
        try {
            model = (OBJModel)MPSOBJLoader.INSTANCE.loadModel(resource);
            model = model.process(ImmutableMap.copyOf((Map)ImmutableMap.of((Object)"flip-v", (Object)"true")));
        }
        catch (Exception e) {
            e.printStackTrace();
            MuseLogger.logError("Model loading failed :( " + resource);
        }
        return model;
    }

    public static IBakedModel loadBakedModel(ResourceLocation resource) {
        IModel model = ModelHelper.getModel(resource);
        if (model != null) {
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation resourceLocation) {
                    return Minecraft.func_71410_x().func_147117_R().func_174942_a(resourceLocation);
                }
            });
            return bakedModel;
        }
        return null;
    }

    public static void transformCalibration() {
        int numsegments = 16;
        if (!tap) {
            if (Keyboard.isKeyDown((int)210)) {
                xOffest = (float)((double)xOffest + 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)211)) {
                xOffest = (float)((double)xOffest - 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)199)) {
                yOffest = (float)((double)yOffest + 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)207)) {
                yOffest = (float)((double)yOffest - 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)201)) {
                zOffest = (float)((double)zOffest + 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)209)) {
                zOffest = (float)((double)zOffest - 0.1);
                tap = true;
            }
            if (Keyboard.isKeyDown((int)79)) {
                ++xtap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)80)) {
                ++ytap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)81)) {
                ++ztap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)75)) {
                --xtap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)76)) {
                --ytap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)77)) {
                --ztap;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)72)) {
                xtap = 0;
                ytap = 0;
                ztap = 0;
                xOffest = 0.0f;
                yOffest = 0.0f;
                zOffest = 0.0f;
                scalemodifier = 1.0f;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)70)) {
                scalemodifier -= 0.01f;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)197)) {
                scalemodifier += 0.01f;
                tap = true;
            }
            if (Keyboard.isKeyDown((int)82)) {
                System.out.println("xrot: " + xtap + ", yrot: " + ytap + ", zrot: " + ztap);
                System.out.println("xOffest: " + xOffest + ", yOffest: " + yOffest + ", zOffest: " + zOffest);
                System.out.println("scaleModifier: " + scalemodifier);
                tap = true;
            }
        } else {
            if (!(Keyboard.isKeyDown((int)82) || Keyboard.isKeyDown((int)79) || Keyboard.isKeyDown((int)80) || Keyboard.isKeyDown((int)81) || Keyboard.isKeyDown((int)75) || Keyboard.isKeyDown((int)76) || Keyboard.isKeyDown((int)77))) {
                tap = false;
            }
            if (Keyboard.isKeyDown((int)42)) {
                tap = false;
            }
        }
    }

    @Nullable
    public static IExtendedBlockState getStateForPart(String shownIn, OBJModel.OBJBakedModel objBakedModelIn) {
        ArrayList<String> hidden = new ArrayList<String>(objBakedModelIn.getModel().getMatLib().getGroups().keySet());
        return ModelHelper.getStateForPart(shownIn, hidden);
    }

    public static IExtendedBlockState getStateForPart(String shownIn, final List<String> hiddenIn) {
        ExtendedBlockState stateContainer = new ExtendedBlockState(null, new IProperty[0], new IUnlistedProperty[]{Properties.AnimationProperty});
        hiddenIn.remove(shownIn);
        try {
            IModelState state = new IModelState(){
                private final Optional<TRSRTransformation> value = Optional.of((Object)TRSRTransformation.identity());

                public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
                    UnmodifiableIterator parts;
                    if (part.isPresent() && (parts = Models.getParts((IModelPart)((IModelPart)part.get()))).hasNext()) {
                        String name = (String)parts.next();
                        if (!parts.hasNext() && hiddenIn.contains(name)) {
                            return this.value;
                        }
                    }
                    return Optional.absent();
                }
            };
            return ((IExtendedBlockState)stateContainer.func_177621_b()).withProperty(Properties.AnimationProperty, (Object)state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BakedQuad> getColoredQuads(List<BakedQuad> quadList, Colour color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : quadList) {
            builder.add((Object)ModelHelper.colorQuad(color, quad));
        }
        return builder.build();
    }

    public static TRSRTransformation get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scale) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(transformX / 16.0f, transformY / 16.0f, transformZ / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(angleX, angleY, angleZ)), new Vector3f(scale, scale, scale), null));
    }

    public static BakedQuad colorQuad(Colour color, BakedQuad quad) {
        ColorTransformer transformer = new ColorTransformer(color, quad.getFormat());
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    static {
        new ModelHelper();
        powerFistLocation = new ResourceLocation(Config.RESOURCE_DOMAIN, "models/item/powerFist/powerFist.obj");
        powerFistFiringLocation = new ResourceLocation(Config.RESOURCE_DOMAIN, "models/item/powerFist/powerFistFiring.obj");
        powerFistLeftLocation = new ResourceLocation(Config.RESOURCE_DOMAIN, "models/item/powerFist/powerFistLeft.obj");
        powerFistLeftFiringLocation = new ResourceLocation(Config.RESOURCE_DOMAIN, "models/item/powerFist/powerFistFiringLeft.obj");
        xtap = 0;
        ytap = 0;
        ztap = 0;
        xOffest = 0.0f;
        yOffest = 0.0f;
        zOffest = 0.0f;
        scalemodifier = 0.625f;
    }

    private static class ColorTransformer
    extends VertexTransformer {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorTransformer(Colour color, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.r = (float)color.r;
            this.g = (float)color.g;
            this.b = (float)color.b;
            this.a = (float)color.a;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.COLOR && data.length >= 4) {
                data[0] = this.r;
                data[1] = this.g;
                data[2] = this.b;
                data[3] = this.a;
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

