/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelPowerFist
implements IBakedModel,
IPerspectiveAwareModel {
    static ItemCameraTransforms.TransformType cameraTransformType;
    static ItemStack itemStack;
    static Item item;
    static Colour colour;
    static World world;
    static EntityLivingBase entity;
    static boolean isFiring;
    static IBakedModel iconModel;
    static LoadingCache<Colour, List<BakedQuad>> powerFistIconCache;
    static LoadingCache<Colour, List<BakedQuad>> powerFistCache;
    static LoadingCache<Colour, List<BakedQuad>> powerFistFiringCache;
    static LoadingCache<Colour, List<BakedQuad>> powerFistLeftCache;
    static LoadingCache<Colour, List<BakedQuad>> powerFistLeftFiringCache;

    public ModelPowerFist(IBakedModel bakedModelIn) {
        if (bakedModelIn instanceof ModelPowerFist) {
            ModelPowerFist cfr_ignored_0 = (ModelPowerFist)bakedModelIn;
        } else {
            iconModel = bakedModelIn;
        }
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformTypeIn) {
        Matrix4f matrix;
        cameraTransformType = cameraTransformTypeIn;
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                matrix = ModelHelper.get(-13.0f, -1.0f, -16.2f, -14.0f, -181.0f, 0.0f, 0.5f).getMatrix();
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                matrix = ModelHelper.get(-18.0f, -0.9f, -19.15f, -15.0f, 180.0f, 0.0f, 0.63f).getMatrix();
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                matrix = ModelHelper.get(-4.8f, -1.0f, -16.2f, -14.0f, -181.0f, 0.0f, 0.5f).getMatrix();
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                matrix = ModelHelper.get(-8.0f, -0.9f, -19.15f, -15.0f, 180.0f, 0.0f, 0.63f).getMatrix();
                break;
            }
            case GROUND: {
                matrix = ModelHelper.get(0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.63f).getMatrix();
                break;
            }
            default: {
                matrix = iconModel != null && iconModel instanceof IPerspectiveAwareModel ? (Matrix4f)((IPerspectiveAwareModel)iconModel).handlePerspective(cameraTransformTypeIn).getValue() : TRSRTransformation.identity().getMatrix();
            }
        }
        return Pair.of((Object)this, (Object)matrix);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List quadList;
        if (side != null) {
            return Collections.EMPTY_LIST;
        }
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case GROUND: {
                if (isFiring) {
                    try {
                        quadList = (List)powerFistFiringCache.get((Object)colour);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        quadList = Collections.EMPTY_LIST;
                    }
                    break;
                }
                try {
                    quadList = (List)powerFistCache.get((Object)colour);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    quadList = Collections.EMPTY_LIST;
                }
                break;
            }
            case FIRST_PERSON_LEFT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                if (isFiring) {
                    try {
                        quadList = (List)powerFistFiringCache.get((Object)colour);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        quadList = Collections.EMPTY_LIST;
                    }
                    break;
                }
                try {
                    quadList = (List)powerFistLeftCache.get((Object)colour);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    quadList = Collections.EMPTY_LIST;
                }
                break;
            }
            default: {
                try {
                    quadList = (List)powerFistIconCache.get((Object)colour);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    quadList = Collections.EMPTY_LIST;
                }
            }
        }
        return quadList;
    }

    public boolean func_177555_b() {
        return iconModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return iconModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return iconModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return iconModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new PowerFistItemOverrideList();
    }

    static {
        isFiring = false;
        powerFistIconCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(iconModel.func_188616_a(null, null, 0L), colour);
            }
        });
        powerFistCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(ModelHelper.powerFist.func_188616_a(null, null, 0L), colour);
            }
        });
        powerFistFiringCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(ModelHelper.powerFistFiring.func_188616_a(null, null, 0L), colour);
            }
        });
        powerFistLeftCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(ModelHelper.powerFistLeft.func_188616_a(null, null, 0L), colour);
            }
        });
        powerFistLeftFiringCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Colour, List<BakedQuad>>(){

            public List<BakedQuad> load(Colour colour) {
                return ModelHelper.getColoredQuads(ModelHelper.powerFistLeftFiring.func_188616_a(null, null, 0L), colour);
            }
        });
    }

    public class PowerFistItemOverrideList
    extends ItemOverrideList {
        public PowerFistItemOverrideList() {
            super(Collections.EMPTY_LIST);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stackIn, World worldIn, EntityLivingBase entityIn) {
            itemStack = stackIn;
            world = worldIn;
            entity = entityIn;
            item = itemStack.func_77973_b();
            colour = ((IModularItemBase)item).getColorFromItemStack(itemStack);
            isFiring = entityIn instanceof EntityPlayer ? itemStack != null && itemStack == entityIn.func_184614_ca() && entityIn.func_184587_cr() && ModuleManager.itemHasActiveModule(itemStack, "Plasma Cannon") : false;
            return originalModel;
        }
    }
}

