/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.MorphTarget;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelPartSpec {
    public ModelSpec modelSpec;
    public MorphTarget morph;
    public String partName;
    public EntityEquipmentSlot slot;
    public int defaultcolourindex;
    public boolean defaultglow;
    public String displayName;
    IExtendedBlockState extendedState;
    List<BakedQuad> quadcache = new ArrayList<BakedQuad>();

    public ModelPartSpec(ModelSpec modelSpec, MorphTarget morph, String partName, EntityEquipmentSlot slot, Integer defaultcolourindex, Boolean defaultglow, String displayName) {
        this.modelSpec = modelSpec;
        this.morph = morph;
        this.partName = partName;
        this.slot = slot;
        this.defaultcolourindex = defaultcolourindex != null ? defaultcolourindex : 0;
        this.defaultglow = defaultglow != null ? defaultglow : false;
        this.displayName = displayName;
        this.extendedState = ModelHelper.getStateForPart(partName, (OBJModel.OBJBakedModel)modelSpec.getModel());
    }

    public List<BakedQuad> getQuads() {
        if (this.quadcache.isEmpty()) {
            this.quadcache = this.modelSpec.getModel().func_188616_a((IBlockState)this.extendedState, null, 0L);
        }
        return this.quadcache;
    }

    public int getColourIndex(NBTTagCompound nbt) {
        return nbt.func_74764_b("colourindex") ? nbt.func_74762_e("colourindex") : this.defaultcolourindex;
    }

    public void setColourIndex(NBTTagCompound nbt, int c) {
        if (c == this.defaultcolourindex) {
            nbt.func_82580_o("colourindex");
        } else {
            nbt.func_74768_a("colourindex", c);
        }
    }

    public boolean getGlow(NBTTagCompound nbt) {
        return nbt.func_74764_b("glow") ? nbt.func_74767_n("glow") : this.defaultglow;
    }

    public void setGlow(NBTTagCompound nbt, boolean g) {
        if (g == this.defaultglow) {
            nbt.func_82580_o("glow");
        } else {
            nbt.func_74757_a("glow", g);
        }
    }

    public void setModel(NBTTagCompound nbt, ModelSpec model) {
        String modelString = (String)ModelRegistry.getInstance().inverse().get(model);
        this.setModel(nbt, modelString != null ? modelString : "");
    }

    public void setModel(NBTTagCompound nbt, String modelname) {
        nbt.func_74778_a("model", modelname);
    }

    public void setPart(NBTTagCompound nbt) {
        nbt.func_74778_a("part", this.partName);
    }

    public NBTTagCompound multiSet(NBTTagCompound nbt, String tex, Boolean glow, Integer c) {
        this.setPart(nbt);
        this.setModel(nbt, this.modelSpec);
        this.setGlow(nbt, glow != null ? glow : false);
        this.setColourIndex(nbt, c != null ? c : this.defaultcolourindex);
        return nbt;
    }
}

