/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.scala.MuseRegistry;
import net.machinemuse.powersuits.client.render.model.MPSOBJLoader;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelRegistry
extends MuseRegistry<ModelSpec> {
    private static ModelRegistry INSTANCE;

    private ModelRegistry() {
    }

    public static ModelRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelRegistry();
        }
        return INSTANCE;
    }

    public IModel getModel(ResourceLocation resource) {
        OBJModel model = null;
        try {
            model = (OBJModel)MPSOBJLoader.INSTANCE.loadModel(resource);
            model = model.process(ImmutableMap.copyOf((Map)ImmutableMap.of((Object)"flip-v", (Object)"true")));
        }
        catch (Exception e) {
            e.printStackTrace();
            MuseLogger.logError("Model loading failed :( " + resource);
        }
        return model;
    }

    public IBakedModel loadBakedModel(ResourceLocation resource) {
        String name = MuseStringUtils.extractName(resource);
        ModelSpec spec = (ModelSpec)this.get(name);
        if (spec == null) {
            return this.wrap(resource);
        }
        return spec.getModel();
    }

    public IBakedModel wrap(ResourceLocation resource) {
        IModel model = this.getModel(resource);
        IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation resourceLocation) {
                return Minecraft.func_71410_x().func_147117_R().func_174942_a(resourceLocation);
            }
        });
        return bakedModel;
    }

    public ModelSpec getModel(NBTTagCompound nbt) {
        return (ModelSpec)this.get(nbt.func_74779_i("model"));
    }

    public ModelPartSpec getPart(NBTTagCompound nbt, ModelSpec model) {
        return (ModelPartSpec)model.get(nbt.func_74779_i("part"));
    }

    public ModelPartSpec getPart(NBTTagCompound nbt) {
        return this.getPart(nbt, this.getModel(nbt));
    }

    public NBTTagCompound getSpecTag(NBTTagCompound museRenderTag, ModelPartSpec spec) {
        String name = this.makeName(spec);
        return museRenderTag.func_74764_b(name) ? museRenderTag.func_74775_l(name) : null;
    }

    public String makeName(ModelPartSpec spec) {
        return spec.modelSpec.getOwnName() + "." + spec.partName;
    }
}

