/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.List;
import net.machinemuse.general.NBTTagAccessor;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.render.RenderState;
import net.machinemuse.powersuits.client.render.item.ArmorModelInstance;
import net.machinemuse.powersuits.client.render.item.IArmorModel;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPart
extends ModelRenderer {
    ModelRenderer parent;

    public RenderPart(ModelBase base, ModelRenderer parent) {
        super(base);
        this.parent = parent;
    }

    public void func_78785_a(float scale) {
        NBTTagCompound renderSpec = ((IArmorModel)ArmorModelInstance.getInstance()).getRenderSpec();
        int[] colours = renderSpec.func_74759_k("colours");
        for (NBTTagCompound nbt : NBTTagAccessor.getValues(renderSpec)) {
            List<BakedQuad> quadList;
            ModelPartSpec part = ModelRegistry.getInstance().getPart(nbt);
            if (part == null || part.slot != ((IArmorModel)ArmorModelInstance.getInstance()).getVisibleSection() || part.morph.apply(ArmorModelInstance.getInstance()) != this.parent || (quadList = part.getQuads()).isEmpty()) continue;
            int ix = part.getColourIndex(nbt);
            int partColor = ix < colours.length && ix >= 0 ? colours[ix] : Colour.WHITE.getInt();
            if (part.getGlow(nbt)) {
                RenderState.glowOn();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.applyTransform();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            part.modelSpec.applyOffsetAndRotation();
            Tessellator tess = Tessellator.func_178181_a();
            VertexBuffer buffer = tess.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            for (BakedQuad quad : part.getQuads()) {
                buffer.func_178981_a(quad.func_178209_a());
                ForgeHooksClient.putQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)partColor);
            }
            tess.func_78381_a();
            GlStateManager.func_179121_F();
            if (!part.getGlow(nbt)) continue;
            RenderState.glowOff();
        }
    }

    private void applyTransform() {
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)this.field_82906_o, (float)(this.field_82908_p - 26.0f), (float)this.field_82907_q);
    }
}

