/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.powermodule.armor.ApiaristArmorModule;
import net.machinemuse.powersuits.powermodule.armor.HazmatModule;
import net.machinemuse.powersuits.powermodule.misc.AirtightSealModule;
import net.machinemuse.powersuits.powermodule.misc.ThaumGogglesModule;
import net.machinemuse.powersuits.powermodule.tool.AppEngWirelessModule;
import net.machinemuse.powersuits.powermodule.tool.ChiselModule;
import net.machinemuse.powersuits.powermodule.tool.GrafterModule;
import net.machinemuse.powersuits.powermodule.tool.OmniProbeModule;
import net.machinemuse.powersuits.powermodule.tool.OmniWrenchModule;
import net.machinemuse.powersuits.powermodule.tool.RefinedStorageWirelessModule;
import net.machinemuse.powersuits.powermodule.tool.ScoopModule;
import net.machinemuse.powersuits.powermodule.tool.TreetapModule;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;

public class ModCompatibility {
    public static boolean isTechRebornLoaded() {
        return Loader.isModLoaded((String)"techreborn");
    }

    public static boolean isGregTechLoaded() {
        return Loader.isModLoaded((String)"gregtech");
    }

    public static boolean isIndustrialCraftLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static final boolean isIndustrialCraftExpLoaded() {
        if (!ModCompatibility.isIndustrialCraftLoaded()) {
            return false;
        }
        List list = Loader.instance().getModList();
        for (ModContainer container : list) {
            if (!container.getModId().toLowerCase().equals("ic2")) continue;
            return container.getName().equals("IndustrialCraft 2");
        }
        return false;
    }

    public static final boolean isIndustrialCraftClassicLoaded() {
        if (!ModCompatibility.isIndustrialCraftLoaded()) {
            return false;
        }
        List list = Loader.instance().getModList();
        for (ModContainer container : list) {
            if (!container.getModId().toLowerCase().equals("ic2")) continue;
            return container.getName().equals("Industrial Craft Classic");
        }
        return false;
    }

    public static boolean isThaumCraftLoaded() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"thermalexpansion") && Loader.isModLoaded((String)"thermalfoundation");
    }

    public static boolean isGalacticraftLoaded() {
        return Loader.isModLoaded((String)"galacticraftcore");
    }

    public static boolean isRFAPILoaded() {
        return ModAPIManager.INSTANCE.hasAPI("cofhapi|energy");
    }

    public static boolean isCOFHLibLoaded() {
        return ModAPIManager.INSTANCE.hasAPI("cofhlib");
    }

    public static boolean isCOFHCoreLoaded() {
        return Loader.isModLoaded((String)"cofhcore");
    }

    public static boolean isForestryLoaded() {
        return Loader.isModLoaded((String)"forestry");
    }

    public static boolean isChiselLoaded() {
        return Loader.isModLoaded((String)"chisel");
    }

    public static boolean isEnderIOLoaded() {
        return Loader.isModLoaded((String)"EnderIO");
    }

    public static boolean isAppengLoaded() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    public static boolean isExtraCellsLoaded() {
        return Loader.isModLoaded((String)"extracells");
    }

    public static boolean isMFRLoaded() {
        return Loader.isModLoaded((String)"MineFactoryReloaded");
    }

    public static boolean isRailcraftLoaded() {
        return Loader.isModLoaded((String)"Railcraft");
    }

    public static boolean isCompactMachinesLoaded() {
        return Loader.isModLoaded((String)"cm2");
    }

    public static boolean isRenderPlayerAPILoaded() {
        return Loader.isModLoaded((String)"RenderPlayerAPI");
    }

    public static boolean isRefinedStorageLoaded() {
        return Loader.isModLoaded((String)"refinedstorage");
    }

    public static boolean isScannableLoaded() {
        return Loader.isModLoaded((String)"scannable");
    }

    public static boolean isWirelessCraftingGridLoaded() {
        return Loader.isModLoaded((String)"wcg");
    }

    public static boolean isMekanismLoaded() {
        return Loader.isModLoaded((String)"Mekanism");
    }

    public static boolean enableThaumGogglesModule() {
        boolean defaultval = ModCompatibility.isThaumCraftLoaded();
        return Config.getConfig().get("Special Modules", "Thaumcraft Goggles Module", defaultval).getBoolean(defaultval);
    }

    public static double getIC2Ratio() {
        return Config.getConfig().get("general", "Energy per IC2 EU", 0.4).getDouble(0.4);
    }

    public static double getRFRatio() {
        return Config.getConfig().get("general", "Energy per RF", 0.1).getDouble(0.1);
    }

    public static double getRSRatio() {
        return Config.getConfig().get("general", "Energy per RS", 0.1).getDouble(0.1);
    }

    public static double getAE2Ratio() {
        return Config.getConfig().get("general", "Energy per AE", 0.2).getDouble(0.2);
    }

    public static void registerModSpecificModules() {
        ModCompatibility.getIC2Ratio();
        ModCompatibility.getRFRatio();
        ModCompatibility.getRSRatio();
        if (ModCompatibility.isCOFHCoreLoaded()) {
            ModuleManager.addModule(new OmniWrenchModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
        }
        if (ModCompatibility.isThaumCraftLoaded() && ModCompatibility.enableThaumGogglesModule()) {
            ModuleManager.addModule(new ThaumGogglesModule(Collections.singletonList((IModularItem)MPSItems.powerArmorHead)));
        }
        if (ModCompatibility.isIndustrialCraftLoaded()) {
            ModuleManager.addModule(new HazmatModule(Arrays.asList((IModularItem)MPSItems.powerArmorHead, (IModularItem)MPSItems.powerArmorTorso, (IModularItem)MPSItems.powerArmorLegs, (IModularItem)MPSItems.powerArmorFeet)));
            ModuleManager.addModule(new TreetapModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
        }
        if (ModCompatibility.isGalacticraftLoaded()) {
            ModuleManager.addModule(new AirtightSealModule(Collections.singletonList((IModularItem)MPSItems.powerArmorHead)));
        }
        if (ModCompatibility.isForestryLoaded()) {
            ModuleManager.addModule(new GrafterModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
            ModuleManager.addModule(new ScoopModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
            ModuleManager.addModule(new ApiaristArmorModule(Arrays.asList((IModularItem)MPSItems.powerArmorHead, (IModularItem)MPSItems.powerArmorTorso, (IModularItem)MPSItems.powerArmorLegs, (IModularItem)MPSItems.powerArmorFeet)));
        }
        if (ModCompatibility.isChiselLoaded()) {
            try {
                ModuleManager.addModule(new ChiselModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
            }
            catch (Exception e) {
                MuseLogger.logException("Couldn't add Chisel module", e);
            }
        }
        if (ModCompatibility.isAppengLoaded()) {
            ModuleManager.addModule(new AppEngWirelessModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
        }
        if (ModCompatibility.isEnderIOLoaded() || ModCompatibility.isMFRLoaded() || ModCompatibility.isRailcraftLoaded()) {
            ModuleManager.addModule(new OmniProbeModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
        }
        if (ModCompatibility.isRefinedStorageLoaded()) {
            ModuleManager.addModule(new RefinedStorageWirelessModule(Collections.singletonList((IModularItem)MPSItems.powerTool)));
        }
    }
}

