/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.proxy;

import net.machinemuse.general.sound.SoundDictionary;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.block.TileEntityTinkerTable;
import net.machinemuse.powersuits.client.render.block.TinkerTableRenderer;
import net.machinemuse.powersuits.client.render.entity.EntityRendererLuxCapacitorEntity;
import net.machinemuse.powersuits.client.render.entity.EntityRendererPlasmaBolt;
import net.machinemuse.powersuits.client.render.entity.EntityRendererSpinningBlade;
import net.machinemuse.powersuits.client.render.model.LuxCapModelHelper;
import net.machinemuse.powersuits.client.render.model.MPSOBJLoader;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.common.proxy.CommonProxy;
import net.machinemuse.powersuits.control.KeybindKeyHandler;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.event.ClientTickHandler;
import net.machinemuse.powersuits.event.ModelBakeEventHandler;
import net.machinemuse.powersuits.event.PlayerUpdateHandler;
import net.machinemuse.powersuits.event.RenderEventHandler;
import net.machinemuse.powersuits.item.ItemComponent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)MPSOBJLoader.INSTANCE);
        MPSOBJLoader.INSTANCE.addDomain("powersuits".toLowerCase());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTinkerTable.class, (TileEntitySpecialRenderer)new TinkerTableRenderer());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        KeybindManager.readInKeybinds();
    }

    @Override
    public void registerEvents() {
        super.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new KeybindKeyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SoundDictionary());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)ModelBakeEventHandler.getInstance());
    }

    @Override
    public void registerRenderers() {
        super.registerRenderers();
        this.regRenderer(MPSItems.powerTool);
        this.regRenderer(MPSItems.powerArmorHead);
        this.regRenderer(MPSItems.powerArmorTorso);
        this.regRenderer(MPSItems.powerArmorLegs);
        this.regRenderer(MPSItems.powerArmorFeet);
        Item components = MPSItems.components;
        if (components != null) {
            ItemComponent cfr_ignored_0 = (ItemComponent)components;
            for (Integer meta : ItemComponent.names.keySet()) {
                ItemComponent cfr_ignored_1 = (ItemComponent)components;
                String oredictName = ItemComponent.names.get(meta);
                ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("powersuits:component/" + oredictName, "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)components, (int)meta, (ModelResourceLocation)itemModelResourceLocation);
                OreDictionary.registerOre((String)oredictName, (ItemStack)new ItemStack(components, 1, meta.intValue()));
            }
        }
        this.regRenderer(Item.func_150898_a((Block)MPSItems.tinkerTable));
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)MPSItems.tinkerTable), (int)0, TileEntityTinkerTable.class);
        Item item = Item.func_150898_a((Block)MPSItems.luxCapacitor);
        LuxCapModelHelper.getInstance();
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)LuxCapModelHelper.luxCapItemLocation);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpinningBlade.class, EntityRendererSpinningBlade::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaBolt.class, EntityRendererPlasmaBolt::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLuxCapacitor.class, EntityRendererLuxCapacitorEntity::new);
    }

    @Override
    public void sendModeChange(int dMode, String newMode) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        MusePacketModeChangeRequest modeChangePacket = new MusePacketModeChangeRequest((EntityPlayer)player, newMode, player.field_71071_by.field_70461_c);
        PacketSender.sendToServer(modeChangePacket);
    }

    private void regRenderer(Item item) {
        ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
    }
}

