/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.entity;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.machinemuse.powersuits.common.MPSItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityLuxCapacitor
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public Colour color;

    public EntityLuxCapacitor(World par1World) {
        super(par1World);
    }

    public EntityLuxCapacitor(World world, EntityLivingBase shootingEntity, Colour color) {
        this(world, shootingEntity);
        this.color = color;
    }

    public EntityLuxCapacitor(World par1World, EntityLivingBase shootingEntity) {
        super(par1World, shootingEntity);
        Vec3d direction = shootingEntity.func_70040_Z().func_72432_b();
        double speed = 1.0;
        this.field_70159_w = direction.field_72450_a * speed;
        this.field_70181_x = direction.field_72448_b * speed;
        this.field_70179_y = direction.field_72449_c * speed;
        double r = 0.4375;
        double xoffset = 0.1;
        double yoffset = 0.0;
        double zoffset = 0.0;
        double horzScale = Math.sqrt(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c);
        double horzx = direction.field_72450_a / horzScale;
        double horzz = direction.field_72449_c / horzScale;
        this.field_70165_t = shootingEntity.field_70165_t + direction.field_72450_a * xoffset - direction.field_72448_b * horzx * yoffset - horzz * zoffset;
        this.field_70163_u = shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset;
        this.field_70161_v = shootingEntity.field_70161_v + direction.field_72449_c * xoffset - direction.field_72448_b * horzz * yoffset + horzx * zoffset;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - r, this.field_70163_u - 0.0625, this.field_70161_v - r, this.field_70165_t + r, this.field_70163_u + 0.0625, this.field_70161_v + r));
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > 400) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult hitResult) {
        if (!this.field_70128_L && hitResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            EnumFacing dir = hitResult.field_178784_b.func_176734_d();
            int x = hitResult.func_178782_a().func_177958_n() - dir.func_82601_c();
            int y = hitResult.func_178782_a().func_177956_o() - dir.func_96559_d();
            int z = hitResult.func_178782_a().func_177952_p() - dir.func_82599_e();
            if (y > 0) {
                BlockPos blockPos = new BlockPos(x, y, z);
                Block block = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                if (block == null || block.isAir(this.field_70170_p.func_180495_p(blockPos), (IBlockAccess)this.field_70170_p, blockPos)) {
                    Block blockToStickTo = this.field_70170_p.func_180495_p(new BlockPos(hitResult.func_178782_a().func_177958_n(), hitResult.func_178782_a().func_177956_o(), hitResult.func_178782_a().func_177952_p())).func_177230_c();
                    if (blockToStickTo.isNormalCube(this.field_70170_p.func_180495_p(blockPos), (IBlockAccess)this.field_70170_p, blockPos) && !(blockToStickTo instanceof BlockLuxCapacitor) && this.color != null) {
                        this.field_70170_p.func_175656_a(blockPos, (IBlockState)((IExtendedBlockState)MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir)).withProperty(BlockLuxCapacitor.COLOR, (Object)this.color));
                        this.field_70170_p.func_175690_a(blockPos, (TileEntity)new TileEntityLuxCapacitor(this.color));
                    } else {
                        for (EnumFacing d : EnumFacing.field_82609_l) {
                            int xo = x + d.func_82601_c();
                            int yo = y + d.func_96559_d();
                            int zo = z + d.func_82599_e();
                            BlockPos blockPos2 = new BlockPos(xo, yo, zo);
                            blockToStickTo = this.field_70170_p.func_180495_p(new BlockPos(xo, yo, zo)).func_177230_c();
                            if (!blockToStickTo.isNormalCube(this.field_70170_p.func_180495_p(blockPos2), (IBlockAccess)this.field_70170_p, blockPos) || blockToStickTo instanceof BlockLuxCapacitor || this.color == null) continue;
                            this.field_70170_p.func_175656_a(blockPos, (IBlockState)((IExtendedBlockState)MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir)).withProperty(BlockLuxCapacitor.COLOR, (Object)this.color));
                            this.field_70170_p.func_175690_a(blockPos, (TileEntity)new TileEntityLuxCapacitor(this.color));
                            break;
                        }
                    }
                }
                this.func_70106_y();
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.color != null) {
            buffer.writeInt(this.color.getInt());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.color = new Colour(additionalData.readInt());
    }
}

