/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.io.IOException;
import net.machinemuse.powersuits.client.render.model.ArmorIcon;
import net.machinemuse.powersuits.client.render.model.LuxCapModelHelper;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.client.render.model.ModelLuxCapacitor;
import net.machinemuse.powersuits.client.render.model.ModelPowerFist;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBakeEventHandler {
    private static ModelBakeEventHandler ourInstance = new ModelBakeEventHandler();
    private static IRegistry<ModelResourceLocation, IBakedModel> modelRegistry;
    LuxCapModelHelper luxCapHeler = LuxCapModelHelper.getInstance();
    private static boolean firstLoad;
    public static final ModelResourceLocation powerFistIconLocation;
    public static ModelPowerFist powerFistModel;
    public static final ModelResourceLocation powerArmorHeadModelLocation;
    public static final ModelResourceLocation powerArmorChestModelLocation;
    public static final ModelResourceLocation powerArmorLegsModelLocation;
    public static final ModelResourceLocation powerArmorFeetModelLocation;

    public static ModelBakeEventHandler getInstance() {
        return ourInstance;
    }

    private ModelBakeEventHandler() {
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) throws IOException {
        modelRegistry = event.getModelRegistry();
        powerFistModel = new ModelPowerFist((IBakedModel)modelRegistry.func_82594_a((Object)powerFistIconLocation));
        modelRegistry.func_82595_a((Object)powerFistIconLocation, (Object)powerFistModel);
        this.storeLuxCapModel(null);
        for (EnumFacing facing : EnumFacing.values()) {
            this.storeLuxCapModel(facing);
        }
        IBakedModel powerArmorHeadModel = (IBakedModel)modelRegistry.func_82594_a((Object)powerArmorHeadModelLocation);
        IBakedModel powerArmorChestModel = (IBakedModel)modelRegistry.func_82594_a((Object)powerArmorChestModelLocation);
        IBakedModel powerArmorLegsModel = (IBakedModel)modelRegistry.func_82594_a((Object)powerArmorLegsModelLocation);
        IBakedModel powerArmorFeetModel = (IBakedModel)modelRegistry.func_82594_a((Object)powerArmorFeetModelLocation);
        ArmorIcon powerArmorIconModel = new ArmorIcon(powerArmorHeadModel, powerArmorChestModel, powerArmorLegsModel, powerArmorFeetModel);
        modelRegistry.func_82595_a((Object)powerArmorHeadModelLocation, (Object)powerArmorIconModel);
        modelRegistry.func_82595_a((Object)powerArmorChestModelLocation, (Object)powerArmorIconModel);
        modelRegistry.func_82595_a((Object)powerArmorLegsModelLocation, (Object)powerArmorIconModel);
        modelRegistry.func_82595_a((Object)powerArmorFeetModelLocation, (Object)powerArmorIconModel);
        if (firstLoad) {
            firstLoad = false;
        } else {
            ModelHelper.loadArmorModels(true);
        }
    }

    private void storeLuxCapModel(EnumFacing facing) {
        ModelResourceLocation luxCapacitorLocation = this.luxCapHeler.getLocationForFacing(facing);
        IBakedModel modelIn = (IBakedModel)modelRegistry.func_82594_a((Object)luxCapacitorLocation);
        if (modelIn instanceof OBJModel.OBJBakedModel) {
            LuxCapModelHelper.getInstance();
            LuxCapModelHelper.putLuxCapModels(facing, modelIn);
            modelRegistry.func_82595_a((Object)luxCapacitorLocation, (Object)new ModelLuxCapacitor(modelIn));
        }
    }

    static {
        firstLoad = Boolean.parseBoolean(System.getProperty("fml.skipFirstModelBake", "true"));
        powerFistIconLocation = new ModelResourceLocation(Config.RESOURCE_PREFIX + "powerTool", "inventory");
        powerArmorHeadModelLocation = new ModelResourceLocation(MPSItems.powerArmorHead.getRegistryName(), "inventory");
        powerArmorChestModelLocation = new ModelResourceLocation(MPSItems.powerArmorTorso.getRegistryName(), "inventory");
        powerArmorLegsModelLocation = new ModelResourceLocation(MPSItems.powerArmorLegs.getRegistryName(), "inventory");
        powerArmorFeetModelLocation = new ModelResourceLocation(MPSItems.powerArmorFeet.getRegistryName(), "inventory");
    }
}

