/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.util.HashMap;
import java.util.Map;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.sound.SoundDictionary;
import net.machinemuse.numina.common.NuminaConfig;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MovementManager {
    public static final Map<String, Double> playerJumpMultipliers = new HashMap<String, Double>();
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public static double getPlayerJumpMultiplier(EntityPlayer player) {
        if (playerJumpMultipliers.containsKey(player.func_174793_f().func_70005_c_())) {
            return playerJumpMultipliers.get(player.func_174793_f().func_70005_c_());
        }
        return 0.0;
    }

    public static void setPlayerJumpTicks(EntityPlayer player, double number) {
        playerJumpMultipliers.put(player.func_174793_f().func_70005_c_(), number);
    }

    @SubscribeEvent
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.getEntityLiving() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.LEGS)) != null && stack.func_77973_b() instanceof ItemPowerArmor && ModuleManager.itemHasActiveModule(stack, "Jump Assist")) {
            double jumpAssist = ModuleManager.computeModularProperty(stack, "Jump Boost") * 2.0;
            double drain = ModuleManager.computeModularProperty(stack, "Jump Energy Consumption");
            double avail = ElectricItemUtils.getPlayerEnergy(player);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.playerSound(player, SoundDictionary.SOUND_EVENT_JUMP_ASSIST, SoundCategory.PLAYERS, (float)(jumpAssist / 8.0), Float.valueOf(1.0f), false);
            }
            if (drain < avail) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                MovementManager.setPlayerJumpTicks(player, jumpAssist);
                double jumpCompensationRatio = ModuleManager.computeModularProperty(stack, "Jump Exhaustion Compensation");
                if (player.func_70051_ag()) {
                    player.func_71024_bL().func_75113_a((float)(-0.8 * jumpCompensationRatio));
                } else {
                    player.func_71024_bL().func_75113_a((float)(-0.2 * jumpCompensationRatio));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (event.getEntityLiving() instanceof EntityPlayer && (boots = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.FEET)) != null && ModuleManager.itemHasActiveModule(boots, "Shock Absorber") && event.getDistance() > 3.0f) {
            double avail;
            double drain;
            double distanceAbsorb = (double)event.getDistance() * ModuleManager.computeModularProperty(boots, "Distance Reduction");
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.playerSound(player, SoundDictionary.SOUND_EVENT_GUI_INSTALL, SoundCategory.PLAYERS, (float)distanceAbsorb, Float.valueOf(1.0f), false);
            }
            if ((drain = distanceAbsorb * ModuleManager.computeModularProperty(boots, "Impact Energy consumption")) < (avail = ElectricItemUtils.getPlayerEnergy(player))) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                event.setDistance((float)((double)event.getDistance() - distanceAbsorb));
            }
        }
    }

    public static double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        return 0.03920000076293945 * ticks * ticks;
    }
}

