/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.general.sound.SoundDictionary;
import net.machinemuse.numina.common.NuminaConfig;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerUpdateHandler {
    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            boolean foundItem;
            EntityPlayer player = (EntityPlayer)e.getEntity();
            List<ItemStack> modularItemsEquipped = MuseItemUtils.modularItemsEquipped(player);
            double totalWeight = MuseItemUtils.getPlayerWeight(player);
            double weightCapacity = Config.getWeightCapacity();
            for (ItemStack stack : modularItemsEquipped) {
                if (!stack.func_77978_p().func_74764_b("ench")) continue;
                stack.func_77978_p().func_82580_o("ench");
            }
            for (IPlayerTickModule module : ModuleManager.getPlayerTickModules()) {
                boolean foundItemWithModule = false;
                for (ItemStack itemStack : modularItemsEquipped) {
                    if (!module.isValidForItem(itemStack) || !ModuleManager.itemHasActiveModule(itemStack, module.getDataName())) continue;
                    module.onPlayerTickActive(player, itemStack);
                    foundItemWithModule = true;
                }
                if (foundItemWithModule) continue;
                for (ItemStack itemStack : modularItemsEquipped) {
                    module.onPlayerTickInactive(player, itemStack);
                }
            }
            boolean bl = foundItem = modularItemsEquipped.size() > 0;
            if (foundItem) {
                player.field_70143_R = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble(player.field_70181_x, -1000.0, 0.0));
                if (totalWeight > weightCapacity) {
                    player.field_70159_w *= weightCapacity / totalWeight;
                    player.field_70179_y *= weightCapacity / totalWeight;
                }
                MuseHeatUtils.coolPlayer(player, MusePlayerUtils.getPlayerCoolingBasedOnMaterial(player));
                double maxHeat = MuseHeatUtils.getMaxHeat(player);
                double currHeat = MuseHeatUtils.getPlayerHeat(player);
                if (currHeat > maxHeat) {
                    player.func_70097_a(MuseHeatUtils.overheatDamage, (float)(Math.sqrt(currHeat - maxHeat) / 4.0));
                    player.func_70015_d(1);
                } else {
                    player.func_70066_B();
                }
                double velsq2 = MuseMathUtils.sumsq(player.field_70159_w, player.field_70181_x, player.field_70179_y) - 0.5;
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    if (player.field_70160_al && velsq2 > 0.0) {
                        Musique.playerSound(player, SoundDictionary.SOUND_EVENT_GLIDER, SoundCategory.PLAYERS, (float)(velsq2 / 3.0), Float.valueOf(1.0f), true);
                    } else {
                        Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_GLIDER);
                    }
                }
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_GLIDER);
            }
        }
    }
}

