/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.render.MuseIconUtils;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.powersuits.client.render.model.ModelHelper;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderEventHandler {
    private static boolean ownFly;
    private final DrawableMuseRect frame = new DrawableMuseRect(Config.keybindHUDx(), Config.keybindHUDy(), Config.keybindHUDx() + 16.0, Config.keybindHUDy() + 16.0, true, Colour.DARKGREEN.withAlpha(0.2), Colour.GREEN.withAlpha(0.2));

    public RenderEventHandler() {
        ownFly = false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void preTextureStitch(TextureStitchEvent.Pre event) {
        MuseIcon.registerIcons(event);
        ModelHelper.loadArmorModels(false);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution screen = new ScaledResolution(mc);
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.getEntityPlayer().field_71075_bZ.field_75100_b && !event.getEntityPlayer().field_70122_E && this.playerHasFlightOn(event.getEntityPlayer())) {
            event.getEntityPlayer().field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    private boolean playerHasFlightOn(EntityPlayer player) {
        return ModuleManager.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "Jetpack") || ModuleManager.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "Glider") || ModuleManager.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.FEET), "Jet Boots") || ModuleManager.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.HEAD), "Flight Control");
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.getEntityPlayer().field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        ItemStack helmet = e.getEntity().func_184582_a(EntityEquipmentSlot.HEAD);
        if (ModuleManager.itemHasActiveModule(helmet, "Binoculars")) {
            e.setNewfov(e.getNewfov() / (float)ModuleManager.computeModularProperty(helmet, "Field of View"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.getType();
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawKeybindToggles() {
        if (Config.keybindHUDon()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ScaledResolution screen = new ScaledResolution(mc);
            this.frame.setLeft(Config.keybindHUDx());
            this.frame.setTop(Config.keybindHUDy());
            this.frame.setBottom(this.frame.top() + 16.0);
            for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
                if (!kb.displayOnHUD) continue;
                double stringwidth = MuseRenderer.getStringWidth(kb.getLabel());
                this.frame.setWidth(stringwidth + (double)(kb.getBoundModules().size() * 16));
                this.frame.draw();
                MuseRenderer.drawString(kb.getLabel(), this.frame.left() + 1.0, this.frame.top() + 3.0, kb.toggleval ? Colour.RED : Colour.GREEN);
                double x = this.frame.left() + stringwidth;
                for (ClickableModule module : kb.getBoundModules()) {
                    MuseTextureUtils.pushTexture(module.getModule().getStitchedTexture(null));
                    boolean active = false;
                    for (ItemStack stack : MuseItemUtils.modularItemsEquipped((EntityPlayer)player)) {
                        if (!ModuleManager.itemHasActiveModule(stack, module.getModule().getDataName())) continue;
                        active = true;
                    }
                    MuseIconUtils.drawIconAt(x, this.frame.top(), module.getModule().getIcon(null), active ? Colour.WHITE : Colour.DARKGREY.withAlpha(0.5));
                    MuseTextureUtils.popTexture();
                    x += 16.0;
                }
                this.frame.setTop(this.frame.top() + 16.0);
                this.frame.setBottom(this.frame.top() + 16.0);
            }
        }
    }
}

