/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemComponent
extends Item {
    public static Map<Integer, String> descriptions = new HashMap<Integer, String>();
    public static Map<Integer, String> names = new HashMap<Integer, String>();
    public static ItemStack wiring;
    public static ItemStack solenoid;
    public static ItemStack servoMotor;
    public static ItemStack gliderWing;
    public static ItemStack ionThruster;
    public static ItemStack parachute;
    public static ItemStack lvcapacitor;
    public static ItemStack mvcapacitor;
    public static ItemStack hvcapacitor;
    public static ItemStack evcapacitor;
    public static ItemStack basicPlating;
    public static ItemStack advancedPlating;
    public static ItemStack fieldEmitter;
    public static ItemStack laserHologram;
    public static ItemStack carbonMyofiber;
    public static ItemStack controlCircuit;
    public static ItemStack myofiberGel;
    public static ItemStack artificialMuscle;
    public static ItemStack magnet;
    public static ItemStack solarPanel;
    public static ItemStack computerChip;
    public static ItemStack liquidNitrogen;
    public static ItemStack rubberHose;

    public ItemComponent() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(Config.getCreativeTab());
        this.func_77655_b("item.powerArmorComponent.");
    }

    public ItemStack addComponent(int meta, String oredictName, String description) {
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        names.put(meta, oredictName);
        OreDictionary.registerOre((String)oredictName, (ItemStack)stack);
        descriptions.put(meta, description);
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List currentTipList, boolean advancedToolTips) {
        if (Config.doAdditionalInfo()) {
            String message = I18n.func_135052_a((String)"tooltip.componentTooltip", (Object[])new Object[0]);
            message = MuseStringUtils.wrapMultipleFormatTags(message, new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
            currentTipList.add(message);
            String description = descriptions.get(stack.func_77960_j()) != null ? descriptions.get(stack.func_77960_j()) : "";
            currentTipList.addAll(MuseStringUtils.wrapStringToLength(description, 30));
        } else {
            currentTipList.add(Config.additionalInfoInstructions());
        }
    }

    public void populate() {
        wiring = this.addComponent(0, "componentWiring", "A special type of wiring with high voltaic capacity and precision, necessary for the sensitive electronics in power armor.");
        solenoid = this.addComponent(1, "componentSolenoid", "Wires wound around a ferromagnetic core produces a basic electromagnet.");
        servoMotor = this.addComponent(2, "componentServo", "A special type of motor which uses a pulse-modulated signal to enact very precise movements.");
        gliderWing = this.addComponent(3, "componentGliderWing", "A lightweight aerodynamic wing with an electromagnet for quick deployment and retraction.");
        ionThruster = this.addComponent(4, "componentIonThruster", "Essentially a miniature particle accelerator. Accelerates ions to near-light speed to produce thrust.");
        lvcapacitor = this.addComponent(5, "componentLVCapacitor", "A simple capacitor can store and discharge small amounts of energy rapidly.");
        mvcapacitor = this.addComponent(6, "componentMVCapacitor", "A more advanced capacitor which can store more energy at higher voltages.");
        hvcapacitor = this.addComponent(7, "componentHVCapacitor", "A synthetic crystal device which can store and release massive amounts of energy.");
        evcapacitor = this.addComponent(8, "componentEVCapacitor", "The most advanced energy storage device ever created. Now 15% less likely to randomly explode!");
        parachute = this.addComponent(9, "componentParachute", "A simple reusable parachute which can be deployed and recovered in midair.");
        basicPlating = this.addComponent(10, "componentPlatingBasic", "Some carefully-arranged metal armor plates.");
        advancedPlating = this.addComponent(11, "componentPlatingAdvanced", "Some carefully-arranged armor plates of a rare and stronger material");
        fieldEmitter = this.addComponent(12, "componentFieldEmitter", "An advanced device which directly manipulates electromagnetic and gravitational fields in an area.");
        laserHologram = this.addComponent(13, "componentLaserEmitter", "A multicoloured laser array which can cheaply alter the appearance of something.");
        carbonMyofiber = this.addComponent(14, "componentCarbonMyofiber", "A small bundle of carbon fibers, refined for use in artificial muscles.");
        controlCircuit = this.addComponent(15, "componentControlCircuit", "A simple networkable microcontroller for coordinating an individual component.");
        myofiberGel = this.addComponent(16, "componentMyofiberGel", "A thick, conductive paste, perfect for fitting between myofibers in an artificial muscle.");
        artificialMuscle = this.addComponent(17, "componentArtificialMuscle", "An electrical, artificial muscle, with less range of movement than human muscle but orders of magnitude more strength.");
        solarPanel = this.addComponent(18, "componentSolarPanel", "A light sensitive device that will generate electricity from the sun.");
        magnet = this.addComponent(19, "componentMagnet", "A metallic device that generates a magnetic field which pulls items towards the player.");
        computerChip = this.addComponent(20, "componentComputerChip", "An upgraded control circuit that contains a CPU which is capable of more advanced calculations.");
        rubberHose = this.addComponent(21, "componentRubberHose", "A heavily insulated rubber hose capable of withstanding extreme heat or cold");
        liquidNitrogen = this.addComponent(22, "componentLiquidNitrogen", "A bucket of Liquid Nitrogen");
    }

    public String func_77667_c(ItemStack itemStack) {
        String unlocalizedName = names.get(itemStack.func_77960_j());
        unlocalizedName = unlocalizedName != null ? unlocalizedName.replaceAll("\\s", "") : "";
        return "item.powerArmorComponent." + unlocalizedName;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List listToAddTo) {
        for (Integer meta : names.keySet()) {
            listToAddTo.add(new ItemStack((Item)this, 1, meta.intValue()));
        }
    }
}

