/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.machinemuse.api.ApiaristArmor;
import net.machinemuse.api.IArmorTraits;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.item.ArmorModelInstance;
import net.machinemuse.powersuits.client.render.item.IArmorModel;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemElectricArmor;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemPowerArmor
extends ItemElectricArmor
implements ISpecialArmor,
IArmorTraits {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};

    public ItemPowerArmor(int renderIndex, EntityEquipmentSlot entityEquipmentSlot) {
        super(ItemArmor.ArmorMaterial.IRON, renderIndex, entityEquipmentSlot);
        this.func_77625_d(1);
        this.func_77637_a(Config.getCreativeTab());
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int priority = 0;
        if (source.func_76347_k()) {
            DamageSource overheatDamage = MuseHeatUtils.overheatDamage;
            if (!(source == null ? overheatDamage == null : source.equals(overheatDamage))) {
                return new ISpecialArmor.ArmorProperties(priority, 0.25, (int)(25.0 * damage));
            }
        }
        if (ModuleManager.itemHasModule(armor, "Radiation Shielding") && (source.field_76373_n.equals("electricity") || source.field_76373_n.equals("radiation"))) {
            return new ISpecialArmor.ArmorProperties(priority, 0.25, (int)(25.0 * damage));
        }
        double armorDouble2 = player instanceof EntityPlayer ? this.getArmorDouble((EntityPlayer)player, armor) : 2.0;
        double armorDouble = armorDouble2;
        double absorbRatio = 0.04 * armorDouble;
        int absorbMax = (int)armorDouble * 75;
        if (source.func_76363_c()) {
            absorbMax = 0;
            absorbRatio = 0.0;
        }
        return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (type == "overlay") {
            return "powersuits:textures/items/armor/blankarmor.png";
        }
        ItemStack armor = ((EntityLivingBase)entity).func_184582_a(slot);
        if (armor.func_77973_b() instanceof ItemPowerArmor) {
            ItemStack armorChest;
            if (entity instanceof EntityPlayer && (armorChest = ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.CHEST)) != null && armorChest.func_77973_b() instanceof ItemPowerArmor && ModuleManager.itemHasActiveModule(armorChest, "Active Camouflage")) {
                return "powersuits:textures/items/armor/blankarmor.png";
            }
            if (ModuleManager.itemHasActiveModule(stack, "Transparent Armor")) {
                return "powersuits:textures/items/armor/blankarmor.png";
            }
            if (ModuleManager.itemHasActiveModule(armor, "Citizen Joe Style")) {
                if (slot == EntityEquipmentSlot.LEGS) {
                    return "powersuits:textures/items/armor/joearmorpants.png";
                }
                return "powersuits:textures/items/armor/joearmor.png";
            }
            if (!ModuleManager.itemHasActiveModule(armor, "3D Armor")) {
                if (slot == EntityEquipmentSlot.LEGS) {
                    return "powersuits:textures/items/armor/sebkarmorpants.png";
                }
                return "powersuits:textures/items/armor/sebkarmor.png";
            }
        }
        return "powersuits:textures/items/armor/blankarmor.png";
    }

    @Override
    public int func_82814_b(ItemStack stack) {
        Colour c = this.getColorFromItemStack(stack);
        return c.getInt();
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return ModuleManager.itemHasActiveModule(stack, "Custom Colour Module");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStackArmor, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (itemStackArmor != null) {
            if (!ModuleManager.itemHasActiveModule(itemStackArmor, "3D Armor")) {
                return _default;
            }
            ModelBiped model = ArmorModelInstance.getInstance();
            ((IArmorModel)model).setVisibleSection(armorSlot);
            if (itemStackArmor != null) {
                ItemStack armorChest;
                if (entityLiving instanceof EntityPlayer && (armorChest = ((EntityPlayer)entityLiving).func_184582_a(EntityEquipmentSlot.CHEST)) != null && armorChest.func_77973_b() instanceof ItemPowerArmor && ModuleManager.itemHasActiveModule(armorChest, "Active Camouflage")) {
                    ((IArmorModel)model).setVisibleSection(null);
                }
                if (ModuleManager.itemHasActiveModule(itemStackArmor, "Transparent Armor")) {
                    ((IArmorModel)model).setVisibleSection(null);
                }
                ((IArmorModel)model).setRenderSpec(MuseItemUtils.getMuseRenderTag(itemStackArmor, armorSlot));
            }
            return model;
        }
        return _default;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], SharedMonsterAttributes.field_111266_c.func_111108_a(), 0.25, 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
        return ModuleManager.tagHasModule(itemTag, "Red Tint") || ModuleManager.tagHasModule(itemTag, "Green Tint") || ModuleManager.tagHasModule(itemTag, "Blue Tint");
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)this.getArmorDouble(player, armor);
    }

    public double getHeatResistance(EntityPlayer player, ItemStack stack) {
        return MuseHeatUtils.getMaxHeat(stack);
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack stack) {
        double totalArmor = 0.0;
        NBTTagCompound props = MuseItemUtils.getMuseItemTag(stack);
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        double physArmor = ModuleManager.computeModularProperty(stack, "Armor (Physical)");
        double enerArmor = ModuleManager.computeModularProperty(stack, "Armor (Energy)");
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        totalArmor += physArmor;
        if (energy > enerConsum) {
            totalArmor += enerArmor;
        }
        totalArmor = Math.min(Config.getMaximumArmorPerPiece(), totalArmor);
        return totalArmor;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound itemProperties = MuseItemUtils.getMuseItemTag(stack);
        if (entity instanceof EntityPlayer) {
            DamageSource overheatDamage = MuseHeatUtils.overheatDamage;
            if (source == null ? overheatDamage == null : source.equals(overheatDamage)) {
                return;
            }
            if (source.func_76347_k()) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!source.equals(DamageSource.field_76370_b) || MuseHeatUtils.getPlayerHeat(player) < MuseHeatUtils.getMaxHeat(player)) {
                    MuseHeatUtils.heatPlayer(player, damage);
                }
            } else {
                double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
                double drain = enerConsum * (double)damage;
                if (entity instanceof EntityPlayer) {
                    ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entity, drain);
                } else {
                    this.drainMPSEnergyFrom(stack, drain);
                }
            }
        }
    }

    @Override
    @Optional.Method(modid="forestry")
    public boolean protectEntity(EntityLivingBase player, ItemStack armor, String cause, boolean doProtect) {
        return ApiaristArmor.getInstance().protectEntity(player, armor, cause, doProtect);
    }
}

