/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.IMuseElectricItem;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseCommonStrings;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModularItemBase
extends Item
implements IModularItemBase {
    private static ModularItemBase INSTANCE;

    public static ModularItemBase getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModularItemBase();
        }
        return INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        return this.getColorFromItemStack(stack).getInt();
    }

    @Override
    public Colour getGlowFromItemStack(ItemStack stack) {
        if (!ModuleManager.itemHasActiveModule(stack, "Glow Module")) {
            return Colour.LIGHTBLUE;
        }
        double computedred = ModuleManager.computeModularProperty(stack, "Red Glow");
        double computedgreen = ModuleManager.computeModularProperty(stack, "Green Glow");
        double computedblue = ModuleManager.computeModularProperty(stack, "Blue Glow");
        Colour colour = new Colour(MuseMathUtils.clampDouble(computedred, 0.0, 1.0), MuseMathUtils.clampDouble(computedgreen, 0.0, 1.0), MuseMathUtils.clampDouble(computedblue, 0.0, 1.0), 0.8);
        return colour;
    }

    @Override
    public Colour getColorFromItemStack(ItemStack stack) {
        if (!ModuleManager.itemHasActiveModule(stack, "Custom Colour Module")) {
            return Colour.WHITE;
        }
        double computedred = ModuleManager.computeModularProperty(stack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(stack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(stack, "Blue Tint");
        Colour colour = new Colour(MuseMathUtils.clampDouble(computedred, 0.0, 1.0), MuseMathUtils.clampDouble(computedgreen, 0.0, 1.0), MuseMathUtils.clampDouble(computedblue, 0.0, 1.0), 1.0);
        return colour;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(stack, player, currentTipList, advancedToolTips);
    }

    @Override
    public String formatInfo(String string, double value) {
        return string + '\t' + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    public List<String> getLongInfo(EntityPlayer player, ItemStack stack) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Detailed Summary");
        info.add(this.formatInfo("Armor", this.getArmorDouble(player, stack)));
        info.add(this.formatInfo("Energy Storage", this.getCurrentMPSEnergy(stack)) + 'J');
        info.add(this.formatInfo("Weight", MuseCommonStrings.getTotalWeight(stack)) + 'g');
        return info;
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack stack) {
        return 0.0;
    }

    @Override
    public double getPlayerEnergy(EntityPlayer player) {
        return ElectricItemUtils.getPlayerEnergy(player);
    }

    @Override
    public void drainPlayerEnergy(EntityPlayer player, double drainEnergy) {
        ElectricItemUtils.drainPlayerEnergy(player, drainEnergy);
    }

    @Override
    public void givePlayerEnergy(EntityPlayer player, double joulesToGive) {
        ElectricItemUtils.givePlayerEnergy(player, joulesToGive);
    }

    @Override
    public double getCurrentMPSEnergy(ItemStack stack) {
        return MuseElectricItem.getInstance().getCurrentMPSEnergy(stack);
    }

    @Override
    public double getMaxMPSEnergy(ItemStack stack) {
        return MuseElectricItem.getInstance().getCurrentMPSEnergy(stack);
    }

    @Override
    public void setCurrentMPSEnergy(ItemStack stack, double energy) {
        MuseElectricItem.getInstance().setCurrentMPSEnergy(stack, energy);
    }

    @Override
    public double drainMPSEnergyFrom(ItemStack stack, double requested) {
        return MuseElectricItem.getInstance().drainMPSEnergyFrom(stack, requested);
    }

    @Override
    public double giveMPSEnergyTo(ItemStack stack, double provided) {
        return MuseElectricItem.getInstance().giveMPSEnergyTo(stack, provided);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getToolTip(ItemStack itemStack) {
        return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false).toString();
    }

    @Override
    public IMuseElectricItem getManager(ItemStack stack) {
        return MuseElectricItem.getInstance().getManager(stack);
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        MuseElectricItem.getInstance().chargeFromArmor(itemStack, entity);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return MuseElectricItem.getInstance().use(itemStack, amount, entity);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().canProvideEnergy(itemStack);
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getCharge(itemStack);
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getMaxCharge(itemStack);
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getTier(itemStack);
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getTransferLimit(itemStack);
    }

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return MuseElectricItem.getInstance().charge(itemStack, amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return MuseElectricItem.getInstance().discharge(itemStack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return MuseElectricItem.getInstance().canUse(itemStack, amount);
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getChargedItem(itemStack);
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getEmptyItem(itemStack);
    }

    @Override
    public int receiveEnergy(ItemStack stack, int energy, boolean simulate) {
        return MuseElectricItem.getInstance().receiveEnergy(stack, energy, simulate);
    }

    @Override
    public int extractEnergy(ItemStack stack, int energy, boolean simulate) {
        return MuseElectricItem.getInstance().extractEnergy(stack, energy, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return MuseElectricItem.getInstance().getEnergyStored(theItem);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return MuseElectricItem.getInstance().getMaxEnergyStored(theItem);
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getEnergy(itemStack);
    }

    @Override
    public void setEnergy(ItemStack itemStack, double v) {
        MuseElectricItem.getInstance().setEnergy(itemStack, v);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getMaxEnergy(itemStack);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getMaxTransfer(itemStack);
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return MuseElectricItem.getInstance().canReceive(itemStack);
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return MuseElectricItem.getInstance().canSend(itemStack);
    }
}

