/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import java.io.DataInputStream;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.PropertyModifierFlatAdditive;
import net.machinemuse.powersuits.powermodule.PropertyModifierLinearAdditive;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MusePacketPropertyModifierConfig
extends MusePacket {
    EntityPlayer player;
    DataInputStream data;
    private static MusePacketPropertyModifierConfigPackager PACKAGERINSTANCE;

    public MusePacketPropertyModifierConfig(EntityPlayer player, DataInputStream data) {
        this.player = player;
        this.data = data;
    }

    @Override
    public MusePackager packager() {
        return MusePacketPropertyModifierConfig.getPackagerInstance();
    }

    @Override
    public void write() {
        this.writeInt(ModuleManager.getAllModules().size());
        for (IPowerModule module : ModuleManager.getAllModules()) {
            this.writeString(module.getDataName());
            this.writeBoolean(module.isAllowed());
            this.writeInt(module.getPropertyModifiers().size());
            for (Map.Entry<String, List<IPropertyModifier>> entry : module.getPropertyModifiers().entrySet()) {
                this.writeString(entry.getKey());
                List<IPropertyModifier> propmodlist = entry.getValue();
                this.writeInt(propmodlist.size());
                for (IPropertyModifier propmod : propmodlist) {
                    if (propmod instanceof PropertyModifierFlatAdditive) {
                        this.writeDouble(((PropertyModifierFlatAdditive)propmod).valueAdded);
                        continue;
                    }
                    if (propmod instanceof PropertyModifierLinearAdditive) {
                        this.writeDouble(((PropertyModifierLinearAdditive)propmod).multiplier);
                        continue;
                    }
                    this.writeDouble(0.0);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClient(EntityPlayer player) {
        MusePackager d = MusePacketPropertyModifierConfigPackager.getInstance();
        int numModules = d.readInt(this.data);
        for (int i = 0; i < numModules; ++i) {
            String moduleName = d.readString(this.data);
            boolean allowed = d.readBoolean(this.data);
            IPowerModule module = ModuleManager.getModule(moduleName);
            if (module instanceof PowerModuleBase) {
                ((PowerModuleBase)module).setIsAllowed(allowed);
            }
            int numProps = d.readInt(this.data);
            for (int j = 0; j < numProps; ++j) {
                String propName = d.readString(this.data);
                int numModifiers = d.readInt(this.data);
                List<IPropertyModifier> proplist = module.getPropertyModifiers().get(propName);
                for (int m = 0; m < numModifiers; ++m) {
                    IPropertyModifier propMod = proplist.get(m);
                    if (propMod instanceof PropertyModifierFlatAdditive) {
                        ((PropertyModifierFlatAdditive)propMod).valueAdded = d.readDouble(this.data);
                        continue;
                    }
                    if (propMod instanceof PropertyModifierLinearAdditive) {
                        ((PropertyModifierLinearAdditive)propMod).multiplier = d.readDouble(this.data);
                        continue;
                    }
                    d.readDouble(this.data);
                }
            }
        }
    }

    public static MusePacketPropertyModifierConfigPackager getPackagerInstance() {
        if (PACKAGERINSTANCE == null) {
            PACKAGERINSTANCE = new MusePacketPropertyModifierConfigPackager();
        }
        return PACKAGERINSTANCE;
    }

    public static class MusePacketPropertyModifierConfigPackager
    extends MusePackager {
        @Override
        public MusePacket read(DataInputStream datain, EntityPlayer player) {
            return new MusePacketPropertyModifierConfig(player, datain);
        }
    }
}

