/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import java.io.DataInputStream;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MusePacketTweakRequest
extends MusePacket {
    final EntityPlayer player;
    final int itemSlot;
    final String moduleName;
    final String tweakName;
    double tweakValue;
    private static MusePacketTweakRequestPackager PACKAGERINSTANCE;

    public MusePacketTweakRequest(EntityPlayer player, int itemSlot, String moduleName, String tweakName, double tweakValue) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
        this.tweakName = tweakName;
        this.tweakValue = tweakValue;
    }

    @Override
    public MusePackager packager() {
        return MusePacketTweakRequest.getPackagerInstance();
    }

    @Override
    public void write() {
        this.writeInt(this.itemSlot);
        this.writeString(this.moduleName);
        this.writeString(this.tweakName);
        this.writeDouble(this.tweakValue);
    }

    @Override
    public void handleServer(EntityPlayerMP player) {
        ItemStack stack;
        NBTTagCompound itemTag;
        if (this.moduleName != null && this.tweakName != null && (itemTag = MuseItemUtils.getMuseItemTag(stack = player.field_71071_by.func_70301_a(this.itemSlot))) != null && ModuleManager.tagHasModule(itemTag, this.moduleName)) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(this.moduleName);
            moduleTag.func_74780_a(this.tweakName, MuseMathUtils.clampDouble(this.tweakValue, 0.0, 1.0));
        }
    }

    public static MusePacketTweakRequestPackager getPackagerInstance() {
        if (PACKAGERINSTANCE == null) {
            PACKAGERINSTANCE = new MusePacketTweakRequestPackager();
        }
        return PACKAGERINSTANCE;
    }

    public static class MusePacketTweakRequestPackager
    extends MusePackager {
        @Override
        public MusePacket read(DataInputStream datain, EntityPlayer player) {
            int itemSlot = this.readInt(datain);
            String moduleName = this.readString(datain);
            String tweakName = this.readString(datain);
            double tweakValue = this.readDouble(datain);
            return new MusePacketTweakRequest(player, itemSlot, moduleName, tweakName, tweakValue);
        }
    }
}

