/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class KineticGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_KINETIC_GENERATOR = "Kinetic Generator";
    public static final String KINETIC_ENERGY_GENERATION = "Energy Per 5 Blocks";
    public static final String KINETIC_HEAT_GENERATION = "Heat Generation";

    public KineticGeneratorModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(KINETIC_HEAT_GENERATION, 5.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addBaseProperty(KINETIC_ENERGY_GENERATION, 200.0);
        this.addTradeoffProperty("Energy Generated", KINETIC_ENERGY_GENERATION, 600.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 3000.0, "g");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public String getCategory() {
        return "Energy";
    }

    @Override
    public String getDataName() {
        return MODULE_KINETIC_GENERATOR;
    }

    @Override
    public String getUnlocalizedName() {
        return "kineticGenerator";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!player.field_70160_al) {
            double distance;
            boolean isNotWalking;
            NBTTagCompound tag = MuseItemUtils.getMuseItemTag(item);
            boolean bl = isNotWalking = player.func_184187_bx() != null || player.func_70090_H();
            if (!tag.func_74764_b("x") || isNotWalking) {
                tag.func_74768_a("x", (int)player.field_70165_t);
            }
            if (!tag.func_74764_b("z") || isNotWalking) {
                tag.func_74768_a("z", (int)player.field_70161_v);
            }
            if ((distance = Math.sqrt((tag.func_74762_e("x") - (int)player.field_70165_t) * (tag.func_74762_e("x") - (int)player.field_70165_t) + (tag.func_74762_e("z") - (int)player.field_70161_v) * (tag.func_74762_e("z") - (int)player.field_70161_v))) >= 5.0) {
                tag.func_74768_a("x", (int)player.field_70165_t);
                tag.func_74768_a("z", (int)player.field_70161_v);
                if (player.func_70051_ag()) {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(item, KINETIC_ENERGY_GENERATION));
                    MuseHeatUtils.heatPlayer(player, ModuleManager.computeModularProperty(item, KINETIC_HEAT_GENERATION));
                } else {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(item, KINETIC_ENERGY_GENERATION) / 2.0);
                    MuseHeatUtils.heatPlayer(player, ModuleManager.computeModularProperty(item, KINETIC_HEAT_GENERATION) / 2.0);
                }
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.kineticGenerator;
    }
}

