/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ThermalGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_THERMAL_GENERATOR = "Thermal Generator";
    public static final String THERMAL_ENERGY_GENERATION = "Energy Generation";

    public ThermalGeneratorModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(THERMAL_ENERGY_GENERATION, 25.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addTradeoffProperty("Energy Generated", THERMAL_ENERGY_GENERATION, 25.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 1000.0, "g");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.basicPlating, 1));
    }

    @Override
    public String getCategory() {
        return "Energy";
    }

    @Override
    public String getDataName() {
        return MODULE_THERMAL_GENERATOR;
    }

    @Override
    public String getUnlocalizedName() {
        return "thermalGenerator";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double currentHeat = MuseHeatUtils.getPlayerHeat(player);
        double maxHeat = MuseHeatUtils.getMaxHeat(player);
        if (player.field_70170_p.func_82737_E() % 20L == 0L) {
            if (player.func_70027_ad()) {
                ElectricItemUtils.givePlayerEnergy(player, 4.0 * ModuleManager.computeModularProperty(item, THERMAL_ENERGY_GENERATION));
            } else if (currentHeat >= 200.0) {
                ElectricItemUtils.givePlayerEnergy(player, 2.0 * ModuleManager.computeModularProperty(item, THERMAL_ENERGY_GENERATION));
            } else if (currentHeat / maxHeat >= 0.5) {
                ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(item, THERMAL_ENERGY_GENERATION));
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.thermalGenerator;
    }
}

