/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class InvisibilityModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_ACTIVE_CAMOUFLAGE = "Active Camouflage";
    private final Potion invisibility = Potion.func_180142_b((String)"invisibility");

    public InvisibilityModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.laserHologram, 4));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_ACTIVE_CAMOUFLAGE;
    }

    @Override
    public String getUnlocalizedName() {
        return "invisibility";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        PotionEffect invis = null;
        if (player.func_70644_a(this.invisibility)) {
            invis = player.func_70660_b(this.invisibility);
        }
        if (50.0 < totalEnergy) {
            if (invis == null || invis.func_76459_b() < 210) {
                player.func_70690_d(new PotionEffect(this.invisibility, 500, -3, false, false));
                ElectricItemUtils.drainPlayerEnergy(player, 50.0);
            }
        } else {
            this.onPlayerTickInactive(player, item);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        PotionEffect invis = null;
        if (player.func_70644_a(this.invisibility)) {
            invis = player.func_70660_b(this.invisibility);
        }
        if (invis != null && invis.func_76458_c() == -3) {
            if (player.field_70170_p.field_72995_K) {
                player.func_184596_c(this.invisibility);
            } else {
                player.func_184589_d(this.invisibility);
            }
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.invisibility;
    }
}

