/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class NightVisionModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_NIGHT_VISION = "Night Vision";
    private static Potion nightvision = Potion.func_180142_b((String)"night_vision");

    public NightVisionModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.laserHologram, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public String getCategory() {
        return "Vision";
    }

    @Override
    public String getDataName() {
        return MODULE_NIGHT_VISION;
    }

    @Override
    public String getUnlocalizedName() {
        return "nightVision";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        PotionEffect nightVision = null;
        if (player.func_70644_a(nightvision)) {
            nightVision = player.func_70660_b(nightvision);
        }
        if (totalEnergy > 5.0) {
            if (nightVision == null || nightVision.func_76459_b() < 210) {
                player.func_70690_d(new PotionEffect(nightvision, 500, -3, false, false));
                ElectricItemUtils.drainPlayerEnergy(player, 5.0);
            }
        } else {
            this.onPlayerTickInactive(player, item);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        PotionEffect nightVision = null;
        if (player.func_70644_a(nightvision) && (nightVision = player.func_70660_b(nightvision)).func_76458_c() == -3) {
            if (player.field_70170_p.field_72995_K) {
                player.func_184596_c(nightvision);
            } else {
                player.func_184589_d(nightvision);
            }
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.nightVision;
    }
}

