/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.player.NuminaPlayerUtils;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlinkDriveModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_BLINK_DRIVE = "Blink Drive";
    public static final String BLINK_DRIVE_ENERGY_CONSUMPTION = "Blink Drive Energy Consuption";
    public static final String BLINK_DRIVE_RANGE = "Blink Drive Range";

    public BlinkDriveModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(BLINK_DRIVE_ENERGY_CONSUMPTION, 1000.0, "J");
        this.addBaseProperty(BLINK_DRIVE_RANGE, 5.0, "m");
        this.addTradeoffProperty("Range", BLINK_DRIVE_ENERGY_CONSUMPTION, 3000.0);
        this.addTradeoffProperty("Range", BLINK_DRIVE_RANGE, 59.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_BLINK_DRIVE;
    }

    @Override
    public String getUnlocalizedName() {
        return "blinkDrive";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        SoundEvent enderman_portal = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.endermen.teleport"));
        double range = ModuleManager.computeModularProperty(itemStackIn, BLINK_DRIVE_RANGE);
        double energyConsumption = ModuleManager.computeModularProperty(itemStackIn, BLINK_DRIVE_ENERGY_CONSUMPTION);
        if (ElectricItemUtils.getPlayerEnergy(playerIn) > energyConsumption) {
            NuminaPlayerUtils.resetFloatKickTicks(playerIn);
            ElectricItemUtils.drainPlayerEnergy(playerIn, energyConsumption);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), enderman_portal, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            MuseLogger.logDebug("Range: " + range);
            RayTraceResult hitRayTrace = MusePlayerUtils.doCustomRayTrace(playerIn.field_70170_p, playerIn, true, range);
            MuseLogger.logDebug("Hit:" + hitRayTrace);
            MusePlayerUtils.teleportEntity(playerIn, hitRayTrace);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), enderman_portal, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.blinkDrive;
    }
}

