/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import java.util.Objects;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.movement.AttributeModifier;
import net.machinemuse.powersuits.powermodule.movement.UUID;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_SPRINT_ASSIST = "Sprint Assist";
    public static final String SPRINT_ENERGY_CONSUMPTION = "Sprint Energy Consumption";
    public static final String SPRINT_SPEED_MULTIPLIER = "Sprint Speed Multiplier";
    public static final String SPRINT_FOOD_COMPENSATION = "Sprint Exhaustion Compensation";
    public static final String WALKING_ENERGY_CONSUMPTION = "Walking Energy Consumption";
    public static final String WALKING_SPEED_MULTIPLIER = "Walking Speed Multiplier";
    public static final UUID TAGUUID = new UUID(-7931854408382894632L, -8160638015224787553L);

    public SprintAssistModule(List<IModularItem> validItems) {
        super(validItems);
        this.addSimpleTradeoff(this, "Power", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 10.0, SPRINT_SPEED_MULTIPLIER, "%", 1.0, 2.0);
        this.addSimpleTradeoff(this, "Compensation", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 2.0, SPRINT_FOOD_COMPENSATION, "%", 0.0, 1.0);
        this.addSimpleTradeoff(this, "Walking Assist", WALKING_ENERGY_CONSUMPTION, "J", 0.0, 10.0, WALKING_SPEED_MULTIPLIER, "%", 1.0, 1.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 4));
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (item == player.func_184582_a(EntityEquipmentSlot.LEGS)) {
            double horzMovement = player.field_70140_Q - player.field_70141_P;
            double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
            if (horzMovement > 0.0) {
                if (player.func_70051_ag()) {
                    double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
                    double sprintCost = ModuleManager.computeModularProperty(item, SPRINT_ENERGY_CONSUMPTION);
                    if (sprintCost < totalEnergy) {
                        double sprintMultiplier = ModuleManager.computeModularProperty(item, SPRINT_SPEED_MULTIPLIER);
                        double exhaustionComp = ModuleManager.computeModularProperty(item, SPRINT_FOOD_COMPENSATION);
                        ElectricItemUtils.drainPlayerEnergy(player, sprintCost * horzMovement * 5.0);
                        this.setMovementModifier(item, sprintMultiplier * 1.2);
                        player.func_71024_bL().func_75113_a((float)(-0.01 * exhaustion * exhaustionComp));
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                } else {
                    double cost = ModuleManager.computeModularProperty(item, WALKING_ENERGY_CONSUMPTION);
                    if (cost < totalEnergy) {
                        double walkMultiplier = ModuleManager.computeModularProperty(item, WALKING_SPEED_MULTIPLIER);
                        ElectricItemUtils.drainPlayerEnergy(player, cost * horzMovement * 5.0);
                        this.setMovementModifier(item, walkMultiplier);
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                }
            }
        } else {
            this.onPlayerTickInactive(player, item);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        NBTTagList modifiers;
        if (item != null && !(modifiers = item.func_77978_p().func_150295_c("AttributeModifiers", 10)).func_82582_d()) {
            for (int i = 0; i < modifiers.func_74745_c(); ++i) {
                NBTTagCompound tag = modifiers.func_150305_b(i);
                if (!Objects.equals(new AttributeModifier((NBTTagCompound)tag).name, MODULE_SPRINT_ASSIST)) continue;
                tag.func_74780_a("Amount", 0.0);
            }
        }
    }

    public void setMovementModifier(ItemStack item, double multiplier) {
        NBTTagList modifiers = item.func_77978_p().func_150295_c("AttributeModifiers", 10);
        NBTTagCompound sprintModifiers = new NBTTagCompound();
        item.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)modifiers);
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            NBTTagCompound tag = modifiers.func_150305_b(i);
            if (!Objects.equals(new AttributeModifier((NBTTagCompound)tag).name, MODULE_SPRINT_ASSIST)) continue;
            sprintModifiers = tag;
            sprintModifiers.func_74768_a("Operation", 1);
            sprintModifiers.func_74780_a("Amount", multiplier - 1.0);
            sprintModifiers.func_74778_a("Slot", EntityEquipmentSlot.LEGS.func_188450_d());
        }
        if (sprintModifiers.func_82582_d()) {
            modifiers.func_74742_a((NBTBase)new AttributeModifier(1, TAGUUID, multiplier - 1.0, "generic.movementSpeed", MODULE_SPRINT_ASSIST, EntityEquipmentSlot.LEGS).toNBT());
            modifiers.func_74742_a((NBTBase)new AttributeModifier(0, TAGUUID, 0.25, SharedMonsterAttributes.field_111266_c.func_111108_a(), SharedMonsterAttributes.field_111266_c.func_111108_a(), EntityEquipmentSlot.LEGS).toNBT());
        }
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_SPRINT_ASSIST;
    }

    @Override
    public String getUnlocalizedName() {
        return "sprintAssist";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.sprintAssist;
    }
}

