/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AquaAffinityModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_AQUA_AFFINITY = "Aqua Affinity";
    public static final String AQUA_AFFINITY_ENERGY_CONSUMPTION = "Underwater Energy Consumption";
    public static final String UNDERWATER_HARVEST_SPEED = "Underwater Harvest Speed";

    public AquaAffinityModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 1));
        this.addBaseProperty(AQUA_AFFINITY_ENERGY_CONSUMPTION, 0.0, "J");
        this.addBaseProperty(UNDERWATER_HARVEST_SPEED, 0.2, "%");
        this.addTradeoffProperty("Power", AQUA_AFFINITY_ENERGY_CONSUMPTION, 100.0);
        this.addTradeoffProperty("Power", UNDERWATER_HARVEST_SPEED, 0.8);
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_AQUA_AFFINITY;
    }

    @Override
    public String getUnlocalizedName() {
        return "aquaAffinity";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving.func_70055_a(Material.field_151586_h) || !entityLiving.field_70122_E) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, ModuleManager.computeModularProperty(stack, AQUA_AFFINITY_ENERGY_CONSUMPTION));
        }
        return true;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (event.getNewSpeed() > 1.0f && (player.func_70055_a(Material.field_151586_h) || !player.field_70122_E) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, AQUA_AFFINITY_ENERGY_CONSUMPTION)) {
            event.setNewSpeed((float)((double)(event.getNewSpeed() * 5.0f) * ModuleManager.computeModularProperty(stack, UNDERWATER_HARVEST_SPEED)));
        }
    }

    @Override
    public ItemStack getEmulatedTool() {
        return null;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.aquaAffinity;
    }
}

