/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.ToolHelpers;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ChiselModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_CHISEL = "Chisel";
    public static final String CHISEL_HARVEST_SPEED = "CHISEL Harvest Speed";
    public static final String CHISEL_ENERGY_CONSUMPTION = "CHISEL Energy Consumption";
    private static final ItemStack emulatedTool = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("chisel", "chisel_iron")), 1);

    public ChiselModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z), 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(CHISEL_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(CHISEL_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", CHISEL_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", CHISEL_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_CHISEL;
    }

    @Override
    public String getUnlocalizedName() {
        return "chisel";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        return ToolHelpers.isEffectiveTool(state, emulatedTool) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, CHISEL_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)worldIn, (BlockPos)pos, (ItemStack)emulatedTool)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, ModuleManager.computeModularProperty(stack, CHISEL_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.setNewSpeed((float)((double)event.getNewSpeed() * ModuleManager.computeModularProperty(event.getEntityPlayer().field_71071_by.func_70448_g(), CHISEL_HARVEST_SPEED)));
    }

    @Override
    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(emulatedTool).func_177554_e();
    }
}

