/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.powersuits.powermodule.tool.ToolHelpers;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DiamondPickUpgradeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_DIAMOND_PICK_UPGRADE = "Diamond Drill Upgrade";
    public static final ItemStack emulatedTool = new ItemStack(Items.field_151046_w);

    public DiamondPickUpgradeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addInstallCost(new ItemStack(Items.field_151045_i, 3));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_DIAMOND_PICK_UPGRADE;
    }

    @Override
    public String getUnlocalizedName() {
        return "diamondPickUpgrade";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        return !ToolHelpers.isEffectiveTool(state, PickaxeModule.emulatedTool) && ToolHelpers.isEffectiveTool(state, emulatedTool) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption");
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!ForgeHooks.canToolHarvestBlock((IBlockAccess)worldIn, (BlockPos)pos, (ItemStack)PickaxeModule.emulatedTool) && ForgeHooks.canToolHarvestBlock((IBlockAccess)worldIn, (BlockPos)pos, (ItemStack)emulatedTool)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption"));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.setNewSpeed((float)((double)event.getNewSpeed() * ModuleManager.computeModularProperty(event.getEntityPlayer().field_71071_by.func_70448_g(), "Pickaxe Harvest Speed")));
    }

    @Override
    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.diamondPickUpgrade;
    }
}

