/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MPSTeleporter;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class DimensionalRiftModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_DIMENSIONAL_RIFT = "Dimensional Tear Generator";
    public static final String DIMENSIONAL_RIFT_ENERGY_GENERATION = "Energy Consumption";
    public static final String DIMENSIONAL_RIFT_HEAT_GENERATION = "Heat Generation";

    public DimensionalRiftModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(DIMENSIONAL_RIFT_HEAT_GENERATION, 55.0);
        this.addBaseProperty(DIMENSIONAL_RIFT_ENERGY_GENERATION, 20000.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.defaultTag.func_74757_a("Active", false);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_DIMENSIONAL_RIFT;
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_184187_bx() == null && playerIn.func_184188_bt().isEmpty() && playerIn instanceof EntityPlayerMP) {
            EntityPlayerMP thePlayer = (EntityPlayerMP)playerIn;
            if (thePlayer.field_71093_bK != -1) {
                thePlayer.func_70012_b(0.5, thePlayer.field_70163_u, 0.5, thePlayer.field_70177_z, thePlayer.field_70125_A);
                thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, -1, (Teleporter)new MPSTeleporter(thePlayer.field_71133_b.func_71218_a(-1)));
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(itemStackIn, DIMENSIONAL_RIFT_ENERGY_GENERATION));
                MuseHeatUtils.heatPlayer((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(itemStackIn, DIMENSIONAL_RIFT_HEAT_GENERATION));
            } else if (thePlayer.field_71093_bK == -1 || thePlayer.field_71093_bK == 1) {
                thePlayer.func_70012_b(0.5, thePlayer.field_70163_u, 0.5, thePlayer.field_70177_z, thePlayer.field_70125_A);
            }
            thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, 0, (Teleporter)new MPSTeleporter(thePlayer.field_71133_b.func_71218_a(0)));
            if (thePlayer.field_71093_bK == 0) {
                BlockPos coords;
                BlockPos blockPos = coords = thePlayer instanceof EntityPlayer ? thePlayer.getBedLocation(thePlayer.field_71093_bK) : null;
                if (coords == null || coords.func_177958_n() == 0 && coords.func_177956_o() == 0 && coords.func_177952_p() == 0) {
                    coords = worldIn.func_175694_M();
                }
                int yPos = coords.func_177956_o();
                while (worldIn.func_180495_p(new BlockPos(coords.func_177958_n(), yPos, coords.func_177952_p())).func_177230_c() != Blocks.field_150350_a && worldIn.func_180495_p(new BlockPos(coords.func_177958_n(), yPos + 1, coords.func_177952_p())) != Blocks.field_150350_a) {
                    ++yPos;
                }
                thePlayer.func_70634_a((double)coords.func_177958_n() + 0.5, (double)yPos, (double)coords.func_177952_p() + 0.5);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(itemStackIn, DIMENSIONAL_RIFT_ENERGY_GENERATION));
            MuseHeatUtils.heatPlayer((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(itemStackIn, DIMENSIONAL_RIFT_HEAT_GENERATION));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public String getUnlocalizedName() {
        return "dimRiftGen";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.dimRiftGen;
    }
}

