/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class OmniProbeModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    public static final String MODULE_OMNIPROBE = "Prototype OmniProbe";
    private ItemStack conduitProbe;
    private ItemStack rednetMeter;
    private ItemStack cpmPSD;
    private ItemStack rcMeter;
    private ItemStack prDebugger;

    public OmniProbeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 4));
        ItemStack tHighest = new ItemStack(Items.field_151132_bS);
        if (ModCompatibility.isMFRLoaded()) {
            tHighest = this.rednetMeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("MineFactoryReloaded", "rednet.meter")), 1);
        }
        if (ModCompatibility.isRailcraftLoaded()) {
            tHighest = this.rcMeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Railcraft", "tool.electric.meter")), 1);
        }
        if (ModCompatibility.isEnderIOLoaded()) {
            tHighest = this.conduitProbe = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("EnderIO", "itemConduitProbe")), 1);
        }
        this.addInstallCost(tHighest);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_OMNIPROBE;
    }

    @Override
    public String getUnlocalizedName() {
        return "omniProbe";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int block = Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c());
        if (Loader.isModLoaded((String)"MineFactoryReloaded") && block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("MineFactoryReloaded", "cable.redstone"))))) {
            return this.rednetMeter.func_77973_b().onItemUseFirst(itemStack, player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"Railcraft") && (block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.alpha")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.track")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.epsilon")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.delta")))))) {
            return this.rcMeter.func_77973_b().onItemUseFirst(itemStack, player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"EnderIO") && block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("EnderIO", "blockConduitBundle"))))) {
            return this.conduitProbe.func_77973_b().func_180614_a(itemStack, player, world, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!MuseItemUtils.getEIOFacadeTransparency(item)) {
            MuseItemUtils.setEIONoCompete(item, MODULE_OMNIPROBE);
            MuseItemUtils.setEIOFacadeTransparency(item, true);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (MuseItemUtils.getEIONoCompete(item) != null && !MuseItemUtils.getEIONoCompete(item).isEmpty()) {
            if (MuseItemUtils.getEIONoCompete(item).equals(MODULE_OMNIPROBE)) {
                MuseItemUtils.setEIONoCompete(item, "");
                if (MuseItemUtils.getEIOFacadeTransparency(item)) {
                    MuseItemUtils.setEIOFacadeTransparency(item, false);
                }
            }
        } else if (MuseItemUtils.getEIOFacadeTransparency(item)) {
            MuseItemUtils.setEIOFacadeTransparency(item, false);
        }
    }

    public float minF(float a, float b) {
        return a < b ? a : b;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.omniProbe;
    }
}

